/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.sql.Connection;
import java.util.TimeZone;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public abstract class AbstractDelegatingSessionBuilder
implements SessionBuilder {
    private final SessionBuilder delegate;

    public AbstractDelegatingSessionBuilder(SessionBuilder delegate) {
        this.delegate = delegate;
    }

    @Override
    public Session openSession() {
        return this.delegate.openSession();
    }

    public SessionBuilder interceptor(Interceptor interceptor) {
        this.delegate.interceptor(interceptor);
        return this;
    }

    public SessionBuilder noInterceptor() {
        this.delegate.noInterceptor();
        return this;
    }

    public SessionBuilder statementInspector(StatementInspector statementInspector) {
        this.delegate.statementInspector(statementInspector);
        return this;
    }

    public SessionBuilder connection(Connection connection) {
        this.delegate.connection(connection);
        return this;
    }

    public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
        this.delegate.connectionReleaseMode(connectionReleaseMode);
        return this;
    }

    public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.delegate.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    public SessionBuilder autoClose(boolean autoClose) {
        this.delegate.autoClose(autoClose);
        return this;
    }

    public SessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
        this.delegate.flushBeforeCompletion(flushBeforeCompletion);
        return this;
    }

    public SessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.delegate.tenantIdentifier(tenantIdentifier);
        return this;
    }

    public SessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.delegate.eventListeners(listeners);
        return this;
    }

    public SessionBuilder clearEventListeners() {
        this.delegate.clearEventListeners();
        return this;
    }

    public SessionBuilder jdbcTimeZone(TimeZone timeZone) {
        this.delegate.jdbcTimeZone(timeZone);
        return this;
    }

    public SessionBuilder setQueryParameterValidation(boolean enabled) {
        this.delegate.setQueryParameterValidation(enabled);
        return this;
    }
}

