/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

public class LookaheadStringReader {
    private String string;
    private int index = 0;

    public LookaheadStringReader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("parameter string cannot be null");
        }
        this.string = string;
    }

    public String lookahead() {
        return this.lookahead(1);
    }

    public String lookahead(int lookahead) {
        int newIndex = this.index + lookahead - 1;
        if (newIndex < this.string.length()) {
            return new String(new char[]{this.string.charAt(newIndex)});
        }
        return null;
    }

    public boolean isAtEnd() {
        return this.index >= this.string.length();
    }

    public String readTo(String ... delimeters) {
        return this.readToSB(delimeters).toString();
    }

    public StringBuffer readToSB(String ... delimeters) {
        StringBuffer sb = new StringBuffer();
        while (!this.isAtEnd() && !this.anyEquals(this.lookahead(), delimeters)) {
            sb.append(this.string.charAt(this.index));
            ++this.index;
        }
        return sb;
    }

    public String readToLast(String ... delimeters) {
        return this.readToLastSB(delimeters).toString();
    }

    public StringBuffer readToLastSB(String ... delimeters) {
        StringBuffer sb = new StringBuffer();
        while (!this.isAtEnd() && !this.anyEquals(this.lookahead(), delimeters)) {
            sb.append(this.string.charAt(this.index));
            ++this.index;
        }
        while (!this.isAtEnd() && this.anyEquals(this.lookahead(2), delimeters)) {
            sb.append(this.string.charAt(this.index));
            ++this.index;
        }
        return sb;
    }

    private boolean anyEquals(String s, String[] delimeters) {
        for (String delimeter : delimeters) {
            if (!delimeter.equals(s)) continue;
            return true;
        }
        return false;
    }

    public String read() {
        if (!this.isAtEnd()) {
            String s = new String(new char[]{this.string.charAt(this.index)});
            ++this.index;
            return s;
        }
        return null;
    }

    public int getLocation() {
        return this.index;
    }

    public String around(int c) {
        int to;
        int from = this.index - c;
        if (from < 0) {
            from = 0;
        }
        if ((to = this.index + c) >= this.string.length()) {
            to = this.string.length() - 1;
        }
        return this.string.substring(from, to + 1);
    }
}

