/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.util.SocketFactoryCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class KeyAndTrustManager {
    private static final Logger logger = Logger.getLogger(KeyAndTrustManager.class);
    private static boolean initialised;
    private static SocketFactoryCache selfSignedFactoryCache;
    private static SSLSocketFactory caFactory;
    private static SocketFactoryCache trustAllFactoryCache;
    private static String protocol;

    public static String getClientTrustStore(Configuration configuration, String password) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        String trustStoreFilename = configuration.getString("security", "client-truststore");
        if (trustStoreFilename == null || "".equals(trustStoreFilename)) {
            return null;
        }
        String brokerHost = configuration.getString("messaging", "broker-host");
        URL remoteTrustStore = new URL(configuration.getConfigRootURL() + trustStoreFilename);
        File localTrustStore = new File(DirectoryLayout.getInstance().getSecurityDir() + File.separator + brokerHost + "-" + trustStoreFilename);
        if (!localTrustStore.exists()) {
            logger.info((Object)"keystore file missing, downloading it");
            File downloadTemp = File.createTempFile(localTrustStore.getName(), "", localTrustStore.getParentFile());
            FileUtils.copyURLToFile((URL)remoteTrustStore, (File)downloadTemp);
            if (!downloadTemp.renameTo(localTrustStore)) {
                logger.info((Object)"renaming keystore file failed, maybe other client is running at the same time? (error ignored)");
            }
        }
        return localTrustStore.getPath();
    }

    public static void initialiseTrustStore() throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, KeyManagementException {
        if (!initialised) {
            String trustStorePath;
            caFactory = KeyAndTrustManager.getSocketFactory(null);
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            String password = configuration.getString("security", "storepass");
            if (DirectoryLayout.getInstance().getType() == DirectoryLayout.Type.CLIENT) {
                trustStorePath = KeyAndTrustManager.getClientTrustStore(configuration, password);
            } else {
                trustStorePath = configuration.getString("security", "server-truststore");
                if ("".equals(trustStorePath)) {
                    trustStorePath = null;
                } else if (!new File(trustStorePath).exists()) {
                    throw new RuntimeException("configured trust store file " + trustStorePath + " doesn't exist");
                }
            }
            if (trustStorePath != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", password);
                System.setProperty("javax.net.ssl.trustStore", trustStorePath);
                if (DirectoryLayout.getInstance().getType() == DirectoryLayout.Type.CLIENT) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream inputStream = new FileInputStream(trustStorePath);){
                        trustStore.load(inputStream, password.toCharArray());
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trustStore);
                    selfSignedFactoryCache = new SocketFactoryCache(tmf.getTrustManagers(), protocol);
                }
            }
            trustAllFactoryCache = new SocketFactoryCache(new TrustManager[]{new TrustAllX509TrustManager()}, protocol);
            if (!configuration.getBoolean("security", "verify-hostname")) {
                HttpsURLConnection.setDefaultHostnameVerifier(new TrustAllHostnameVerifier());
            }
            initialised = true;
        }
    }

    private static SSLSocketFactory getSocketFactory(TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, trustManagers, null);
        return ctx.getSocketFactory();
    }

    public static SslContextFactory createSslContextFactory(String keyStore, String keyStorePassword, String[] protocols) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        SslContextFactory sslContextFactory = new SslContextFactory(keyStore);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setIncludeProtocols(protocols);
        return sslContextFactory;
    }

    public static void configureForChipsterCertificate(URLConnection connection) {
        if (selfSignedFactoryCache != null && connection instanceof HttpsURLConnection) {
            try {
                ((HttpsURLConnection)connection).setSSLSocketFactory(selfSignedFactoryCache.getSocketFactoryForThisThread());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                new RuntimeException(e);
            }
        }
    }

    public static void configureForCACertificates(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(caFactory);
        }
    }

    public static void configureForTrustAllCertificates(URLConnection connection) throws NoSuchAlgorithmException, KeyManagementException {
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(trustAllFactoryCache.getSocketFactoryForThisThread());
            ((HttpsURLConnection)connection).setHostnameVerifier(new TrustAllHostnameVerifier());
        }
    }

    static {
        protocol = "TLS";
    }

    public static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    }

    public static class TrustAllX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            throw new NotImplementedException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

