/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import de.schlichtherle.truezip.file.TFile;
import fi.csc.microarray.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.eclipse.jetty.util.IO;

public class Files {
    public static boolean delTree(File dir) throws IOException {
        if (dir.delete()) {
            return true;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                Files.delTree(file);
            }
            return dir.delete();
        }
        return false;
    }

    public static byte[] inputStreamToBytes(InputStream input) throws IOException {
        return Files.inputStreamToBytes(input, -1L);
    }

    public static byte[] inputStreamToBytes(InputStream input, long byteCount) throws IOException {
        if (input == null) {
            throw new NullPointerException("parameter input is null.");
        }
        BufferedInputStream in = new BufferedInputStream(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (byteCount == -1L) {
            IO.copy((InputStream)in, (OutputStream)out);
        } else {
            IO.copy((InputStream)in, (OutputStream)out, (long)byteCount);
        }
        return out.toByteArray();
    }

    public static String fileToString(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("parameter file is null.");
        }
        try (FileInputStream s = new FileInputStream(file);){
            String string = Files.inputStreamToString(new FileInputStream(file));
            return string;
        }
    }

    public static String inputStreamToString(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("parameter input is null.");
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(input));
        String line = inputReader.readLine();
        while (line != null) {
            buffer.append(line + "\n");
            line = inputReader.readLine();
        }
        return buffer.toString();
    }

    public static boolean sweepAndCreateDirectory(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                return false;
            }
            if (!Files.delTree(dir)) {
                return false;
            }
        }
        return dir.mkdir();
    }

    public static boolean equalInputStreamContent(InputStream input1, InputStream input2) throws IOException {
        BufferedInputStream in1 = new BufferedInputStream(input1);
        BufferedInputStream in2 = new BufferedInputStream(input2);
        boolean equal = true;
        int byte1 = ((InputStream)in1).read();
        while (byte1 != -1 && equal) {
            if (byte1 != ((InputStream)in2).read()) {
                equal = false;
            }
            byte1 = ((InputStream)in1).read();
        }
        if (((InputStream)in2).read() != -1) {
            equal = false;
        }
        return equal;
    }

    public static void cleanOldFiles(File baseDir, long cutoff) throws IOException {
        Files.walkAndDelete(baseDir, (IOFileFilter)new AgeFileFilter(System.currentTimeMillis() - cutoff));
    }

    public static void walkAndDelete(File baseDir, IOFileFilter filter) throws IOException {
        File[] files = baseDir.listFiles((FileFilter)new OrFileFilter(DirectoryFileFilter.INSTANCE, filter));
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.delete() || !f.isDirectory()) continue;
            boolean toBeDeleted = false;
            if (filter.accept(f)) {
                toBeDeleted = true;
            }
            Files.walkAndDelete(f, filter);
            if (!toBeDeleted) continue;
            f.delete();
        }
    }

    public static String[] parseFilename(File file) {
        String extension;
        String name;
        String path = file.getParent() != null ? file.getParent() : "";
        String wholeName = file.getName();
        if (wholeName.contains(".")) {
            name = wholeName.substring(0, wholeName.indexOf(46));
            extension = wholeName.substring(wholeName.indexOf(46) + 1);
        } else {
            name = wholeName;
            extension = "";
        }
        return new String[]{path, name, extension};
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static File[] findFiles(File dir, String regex) {
        class RegexFileFilter
        implements FilenameFilter {
            private String regex;

            public RegexFileFilter(String regex) {
                this.regex = regex;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(this.regex);
            }
        }
        return dir.listFiles(new RegexFileFilter(regex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSymbolicLink(File from, File to) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"ln", "-s", from.getCanonicalPath(), to.getCanonicalPath()});
            process.waitFor();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static List<File> listFilesRecursively(File file) {
        LinkedList<File> files = new LinkedList<File>();
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                files.addAll(Files.listFilesRecursively(subFile));
            }
        } else {
            files.add(file);
        }
        return files;
    }

    public static void makeSpaceInDirectoryPercentage(File dir, int percentage) {
        Files.makeSpaceInDirectoryPercentage(dir, percentage, 0, TimeUnit.SECONDS);
    }

    public static void makeSpaceInDirectoryPercentage(File dir, int percentage, int minimumFileAge, TimeUnit minimumFileAgeTimeUnit) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory");
        }
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("percentage " + percentage + " not between 0 and 100");
        }
        if (Files.partitionHasUsableSpacePercentage(dir, percentage)) {
            return;
        }
        List<File> files = Files.listFilesRecursivelySortByDateOldestFirst(dir);
        for (File file : files) {
            long minimumMilliseconds = minimumFileAgeTimeUnit.toMillis(minimumFileAge);
            if (System.currentTimeMillis() - file.lastModified() <= minimumMilliseconds) {
                return;
            }
            if (!file.delete() || !Files.partitionHasUsableSpacePercentage(dir, percentage)) continue;
            return;
        }
    }

    public static void makeSpaceInDirectory(File dir, long size) {
        Files.makeSpaceInDirectory(dir, size, 0, TimeUnit.SECONDS);
    }

    public static void makeSpaceInDirectory(File dir, long size, int minimumFileAge, TimeUnit minimumFileAgeTimeUnit) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory");
        }
        if (Files.partitionHasUsableSpaceBytes(dir, size)) {
            return;
        }
        List<File> files = Files.listFilesRecursivelySortByDateOldestFirst(dir);
        for (File file : files) {
            long minimumMilliseconds = minimumFileAgeTimeUnit.toMillis(minimumFileAge);
            if (System.currentTimeMillis() - file.lastModified() <= minimumMilliseconds) {
                return;
            }
            if (!file.delete() || !Files.partitionHasUsableSpaceBytes(dir, size)) continue;
            return;
        }
    }

    public static List<File> listFilesRecursivelySortByDateOldestFirst(File dir) {
        List<File> sortedFiles = Files.listFilesRecursively(dir).stream().map(file -> new DateFile(file.lastModified(), (File)file)).sorted((d1, d2) -> Long.compare(d1.date, d2.date)).map(dateFile -> dateFile.file).collect(Collectors.toList());
        return sortedFiles;
    }

    public static boolean partitionHasUsableSpacePercentage(File file, int percentage) {
        return (double)file.getUsableSpace() / (double)file.getTotalSpace() * 100.0 >= (double)percentage;
    }

    public static boolean partitionHasUsableSpaceBytes(File file, long bytes) {
        return file.getUsableSpace() >= bytes;
    }

    public static File getLatestVersion(File dir, final String basename, final String extension) {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(basename + "-")) {
                    return false;
                }
                String versionString = null;
                if (extension != null) {
                    if (!name.endsWith("." + extension)) {
                        return false;
                    }
                    versionString = name.substring(basename.length() + 1, name.lastIndexOf(extension) - 1);
                } else {
                    if (!new TFile(dir, name).isDirectory()) {
                        return false;
                    }
                    versionString = name.substring(basename.length() + 1);
                }
                Version v = null;
                try {
                    v = Version.parse(versionString);
                }
                catch (Exception e) {
                    return false;
                }
                return v != null;
            }
        });
        File latest = null;
        Version latestVersion = null;
        for (File f : files) {
            String n = f.getName();
            String versionString = extension != null ? n.substring(basename.length() + 1, n.lastIndexOf(extension) - 1) : n.substring(basename.length() + 1);
            Version v = Version.parse(versionString);
            if (latest == null) {
                latest = f;
                latestVersion = v;
                continue;
            }
            if (latestVersion.compareTo(v) >= 0) continue;
            latest = f;
            latestVersion = v;
        }
        return latest;
    }

    public static Set<PosixFilePermission> get644Permissions() {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        return perms;
    }

    public static Set<PosixFilePermission> get755Permissions() {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        return perms;
    }

    public static class DateFile {
        public Long date;
        public File file;

        DateFile(Long date, File file) {
            this.date = date;
            this.file = file;
        }
    }
}

