/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class UrlListMessage
extends ChipsterMessage {
    private static final String KEY_URL_LIST = "url-list";
    private static final String URL_DELIMITER = "\n";
    private List<URL> urlList;

    public UrlListMessage() {
    }

    public UrlListMessage(List<URL> url) {
        this.urlList = url;
    }

    public List<URL> getUrlList() {
        return this.urlList;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        try {
            String messageString = from.getString(KEY_URL_LIST);
            String[] urlArray = messageString.split(URL_DELIMITER);
            this.urlList = new LinkedList<URL>();
            for (String urlString : urlArray) {
                this.urlList.add(new URL(urlString));
            }
        }
        catch (MalformedURLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        String messageString = "";
        for (URL url : this.urlList) {
            messageString = messageString + url.toString() + URL_DELIMITER;
        }
        mapMessage.setString(KEY_URL_LIST, messageString);
    }
}

