/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.util.Exceptions;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class SuccessMessage
extends ChipsterMessage {
    private static final Logger logger = Logger.getLogger(SuccessMessage.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    private static final String KEY_DETAILS = "details";
    private static final String KEY_EXCEPTION = "exception";
    private boolean success;
    private String errorMessage;
    private String details;
    private Exception exception;
    private String exceptionString;

    public SuccessMessage(boolean success) {
        this.success = success;
    }

    public SuccessMessage(boolean success, String errorMessage, String details, Exception exception) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.details = details;
        this.exception = exception;
    }

    public SuccessMessage(boolean success, String errorMessage, Exception exception) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.exception = exception;
    }

    public SuccessMessage(boolean success, String errorMessage, String details) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.details = details;
    }

    public SuccessMessage(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public SuccessMessage(boolean success, Exception exception) {
        this.success = success;
        this.exception = exception;
    }

    public SuccessMessage() {
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.success = from.getBoolean(KEY_SUCCESS);
        this.errorMessage = from.getString(KEY_ERROR_MESSAGE);
        this.details = from.getString(KEY_DETAILS);
        this.exceptionString = from.getString(KEY_EXCEPTION);
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        mapMessage.setBoolean(KEY_SUCCESS, this.success);
        mapMessage.setString(KEY_ERROR_MESSAGE, this.errorMessage);
        mapMessage.setString(KEY_DETAILS, this.details);
        if (this.exception != null) {
            mapMessage.setString(KEY_EXCEPTION, this.exception.getMessage() + Exceptions.getStackTrace(this.exception));
        }
    }

    public boolean success() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setException(Exception e) {
        this.exception = e;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    @Override
    public String toString() {
        return "errorMessage: " + this.errorMessage + "\ndetails: " + this.details + "\nexception: " + this.exceptionString + "\n";
    }
}

