/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.messaging.message.JobMessage;
import java.util.Iterator;
import java.util.List;

public class JobMessageUtils {
    public static List<String> checkParameterSafety(JobMessage.ParameterSecurityPolicy securityPolicy, ToolDescription description, List<String> parameters) throws JobMessage.ParameterValidityException {
        if (securityPolicy == null) {
            throw new IllegalArgumentException("security policy cannot be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("tool description cannot be null");
        }
        int parameterDescriptionCount = 0;
        Iterator<ToolDescription.ParameterDescription> iterator = description.getParameters().iterator();
        while (iterator.hasNext()) {
            ++parameterDescriptionCount;
            iterator.next();
        }
        if (parameterDescriptionCount != parameters.size()) {
            throw new IllegalArgumentException("number of parameter descriptions does not match the number of parameter values");
        }
        Iterator<ToolDescription.ParameterDescription> descriptionIterator = description.getParameters().iterator();
        for (String parameter : parameters) {
            ToolDescription.ParameterDescription parameterDescription = descriptionIterator.next();
            if (parameterDescription.isChecked()) {
                if (securityPolicy.isValueValid(parameter, parameterDescription)) continue;
                throw new JobMessage.ParameterValidityException("illegal value for parameter " + parameterDescription.getName() + ": " + parameter);
            }
            if (securityPolicy.allowUncheckedParameters()) continue;
            throw new UnsupportedOperationException("unchecked parameters are not allowed");
        }
        return parameters;
    }
}

