/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.util.Strings;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class AdminAPI {
    private Lock mutex = new ReentrantLock();
    private static final Logger logger = Logger.getLogger(AdminAPI.class);
    private static final int SERVICE_CHECK_MAX_WAITTIME = 20;
    private static final int SERVICE_CHECK_MIN_WAITTIME = 5;
    public static final int NAME_PARAMETER_INDEX = 0;
    public static final int HOST_PARAMETER_INDEX = 1;
    private MessagingListener adminListener = new MessagingListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            AdminAPI.this.mutex.lock();
            try {
                CommandMessage cmdMsg = (CommandMessage)msg;
                if (cmdMsg.getCommand().equals("ping-reply")) {
                    String name = cmdMsg.getParameters().get(0);
                    String host = cmdMsg.getParameters().get(1);
                    logger.debug((Object)(name + " is up"));
                    NodeStatus status = (NodeStatus)AdminAPI.this.nodeStatuses.get(name);
                    if (status != null) {
                        status.addHost(host);
                        if (status.getCount() >= status.requiredCount) {
                            status.status = NodeStatus.Status.UP;
                        }
                        AdminAPI.this.notifyListener();
                    }
                }
            }
            finally {
                AdminAPI.this.mutex.unlock();
            }
        }
    };
    private MessagingTopic adminTopic;
    private Map<String, NodeStatus> nodeStatuses = new LinkedHashMap<String, NodeStatus>();
    private AdminAPILIstener listener;
    private String errorStatus = "";

    public AdminAPI(MessagingTopic adminTopic, AdminAPILIstener listener) throws JMSException {
        this.listener = listener;
        this.adminTopic = adminTopic;
        adminTopic.setListener(this.adminListener);
        this.mutex.lock();
        try {
            this.nodeStatuses.put("authenticator", new NodeStatus("authenticator"));
            this.nodeStatuses.put("comp", new NodeStatus("comp"));
            this.nodeStatuses.put("filebroker", new NodeStatus("filebroker"));
            this.nodeStatuses.put("manager", new NodeStatus("manager"));
            this.nodeStatuses.put("jobmanager", new NodeStatus("jobmanager"));
            this.nodeStatuses.put("client", new NodeStatus("client"));
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void setRequiredCountFor(String nodeName, int requiredCount) {
        this.mutex.lock();
        try {
            this.nodeStatuses.get((Object)nodeName).requiredCount = requiredCount;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public String getErrorStatus() {
        return this.errorStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllServicesUp(boolean fastCheck) throws InterruptedException, JMSException {
        this.ping();
        boolean allServicesUp = false;
        int seconds = 0;
        while (true) {
            Thread.sleep(1024L);
            allServicesUp = this.areAlreadyUp();
            if (allServicesUp && (fastCheck || seconds >= 5) || seconds >= 20) break;
            ++seconds;
        }
        this.mutex.lock();
        try {
            for (NodeStatus nodeStatus : this.nodeStatuses.values()) {
                if (nodeStatus.status != NodeStatus.Status.UNKNOWN) continue;
                nodeStatus.status = NodeStatus.Status.DOWN;
            }
        }
        finally {
            this.mutex.unlock();
        }
        return allServicesUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateStatusReport() {
        String report = "";
        this.mutex.lock();
        try {
            for (NodeStatus status : this.nodeStatuses.values()) {
                report = report + status.name + ": count " + status.getCount() + ", host(s) " + Strings.delimit(status.getHosts(), ", ") + "\n";
            }
        }
        finally {
            this.mutex.unlock();
        }
        return report;
    }

    private boolean areAlreadyUp() {
        this.errorStatus = "";
        boolean areUp = true;
        this.mutex.lock();
        try {
            if (this.nodeStatuses.get((Object)"filebroker").status != NodeStatus.Status.UP) {
                this.errorStatus = this.errorStatus + " filebroker(s) not up ";
                areUp = false;
            }
            if (this.nodeStatuses.get((Object)"comp").status != NodeStatus.Status.UP) {
                this.errorStatus = this.errorStatus + " comp(s) not up ";
                areUp = false;
            }
            if (this.nodeStatuses.get((Object)"authenticator").status != NodeStatus.Status.UP) {
                this.errorStatus = this.errorStatus + " authenticator(s) not up ";
                areUp = false;
            }
            if (this.nodeStatuses.get((Object)"jobmanager").status != NodeStatus.Status.UP) {
                this.errorStatus = this.errorStatus + " jobmanager not up ";
                areUp = false;
            }
        }
        finally {
            this.mutex.unlock();
        }
        return areUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener() {
        if (this.listener != null) {
            this.mutex.lock();
            try {
                LinkedHashMap<String, NodeStatus> copy = new LinkedHashMap<String, NodeStatus>();
                for (String key : this.nodeStatuses.keySet()) {
                    copy.put(key, new NodeStatus(this.nodeStatuses.get(key)));
                }
                this.listener.statusUpdated(copy);
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    private void ping() throws JMSException {
        CommandMessage pingMsg = new CommandMessage("ping");
        this.adminTopic.sendMessage(pingMsg);
    }

    public static class NodeStatus {
        public final String name;
        private HashSet<String> hosts = new HashSet();
        public Status status = Status.UNKNOWN;
        public int requiredCount = 0;

        public NodeStatus(NodeStatus other) {
            this.name = other.name;
            this.hosts = new HashSet<String>(other.hosts);
            this.status = other.status;
            this.requiredCount = other.requiredCount;
        }

        public NodeStatus(String name) {
            this.name = name;
        }

        public NodeStatus(String name, int requiredCount) {
            this(name);
            this.requiredCount = requiredCount;
        }

        public void addHost(String host) {
            this.hosts.add(host);
        }

        public int getCount() {
            return this.hosts.size();
        }

        public HashSet<String> getHosts() {
            return this.hosts;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.name + ": " + (Object)((Object)this.status) + "(" + this.getCount() + " hosts)";
        }

        public static enum Status {
            UP,
            DOWN,
            UNKNOWN;

        }
    }

    public static interface AdminAPILIstener {
        public void statusUpdated(Map<String, NodeStatus> var1);
    }
}

