/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.description.SADLTokeniser;
import fi.csc.microarray.util.Strings;
import java.util.List;

public class SADLGenerator {
    public static String generate(SADLDescription sadl) {
        String string = "TOOL " + SADLGenerator.generateName(sadl.getName()) + " (" + SADLGenerator.escapeIfNeeded(sadl.getDescription()) + ")\n";
        string = string + SADLGenerator.generateInputs("INPUT", sadl.getInputs());
        string = string + SADLGenerator.generateOutputs("OUTPUT", sadl.getOutputs());
        if (!sadl.getParameters().isEmpty()) {
            for (SADLDescription.Parameter parameter : sadl.getParameters()) {
                boolean first;
                String paramString = "PARAMETER " + SADLGenerator.generateOptional(parameter) + parameter.getName() + " TYPE ";
                if (parameter.getType() == SADLSyntax.ParameterType.ENUM) {
                    paramString = paramString + "[";
                    first = true;
                    for (SADLDescription.Name option : parameter.getSelectionOptions()) {
                        if (!first) {
                            paramString = paramString + ", ";
                        } else {
                            first = false;
                        }
                        paramString = paramString + option;
                    }
                    paramString = paramString + "] ";
                } else {
                    paramString = paramString + (Object)((Object)parameter.getType()) + " ";
                }
                if (parameter.getFrom() != null) {
                    paramString = paramString + "FROM " + parameter.getFrom() + " ";
                }
                if (parameter.getTo() != null) {
                    paramString = paramString + "TO " + parameter.getTo() + " ";
                }
                if (parameter.getDefaultValues().length > 0) {
                    paramString = paramString + "DEFAULT ";
                    first = true;
                    for (String defaultValue : parameter.getDefaultValues()) {
                        paramString = paramString + (first ? "" : ",");
                        paramString = paramString + SADLGenerator.quoteIfNeeded(defaultValue) + " ";
                        first = false;
                    }
                }
                paramString = paramString + SADLGenerator.possibleComment(parameter.getDescription());
                string = string + paramString + "\n";
            }
        }
        if (sadl.getRuntime() != null && !sadl.getRuntime().isEmpty()) {
            string = string + "RUNTIME " + sadl.getRuntime() + "\n";
        }
        if (sadl.getSlotCount() != null) {
            string = string + "SLOTS " + sadl.getRuntime() + "\n";
        }
        return string;
    }

    private static String possibleComment(String comment) {
        if (comment != null) {
            return "(" + SADLGenerator.escapeIfNeeded(comment) + ")";
        }
        return "";
    }

    private static String generateOutputs(String header, List<SADLDescription.Output> outputList) {
        String string = "";
        if (!outputList.isEmpty()) {
            for (SADLDescription.Output output : outputList) {
                string = string + header + " " + SADLGenerator.generateExtensions(output) + SADLGenerator.generateName(output.getName()) + " " + SADLGenerator.possibleComment(output.getDescription()) + "\n";
            }
        }
        return string;
    }

    private static String generateInputs(String header, List<SADLDescription.Input> inputList) {
        String string = "";
        if (!inputList.isEmpty()) {
            for (SADLDescription.Input input : inputList) {
                string = string + header + " " + SADLGenerator.generateExtensions(input) + SADLGenerator.generateName(input.getName()) + " TYPE " + input.getType().getName() + " " + SADLGenerator.possibleComment(input.getDescription()) + "\n";
            }
        }
        return string;
    }

    private static String generateExtensions(SADLDescription.IOEntity entity) {
        return (entity.isMeta() ? "META " : "") + SADLGenerator.generateOptional(entity);
    }

    private static String generateOptional(SADLDescription.Entity entity) {
        return entity.isOptional() ? "OPTIONAL " : "";
    }

    public static String generateName(SADLDescription.Name name) {
        String firstPart = name.isNameSet() ? name.getPrefix() + "{...}" + name.getPostfix() : name.getID();
        String secondPart = name.getDisplayName() != null ? ": " + SADLGenerator.quoteIfNeeded(name.getDisplayName()) : "";
        return SADLGenerator.quoteIfNeeded(firstPart) + secondPart;
    }

    private static String quoteIfNeeded(String string) {
        if (string.isEmpty() || string.contains(" ") || Strings.containsAnyOf(string, true, SADLTokeniser.tokenEndingOperators())) {
            return "\"" + SADLGenerator.escapeIfNeeded(string) + "\"";
        }
        return string;
    }

    private static String escapeIfNeeded(String string) {
        if (string != null) {
            for (String operator : SADLTokeniser.blockEndingOperators()) {
                string = string.replace(operator, "\\" + operator);
            }
            return string;
        }
        return null;
    }
}

