/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.chipster.toolbox.RuntimeUtils;
import fi.csc.microarray.comp.CompException;
import fi.csc.microarray.comp.JobFactory;
import fi.csc.microarray.comp.ToolRuntime;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RuntimeRepository {
    private static final Logger logger = Logger.getLogger(RuntimeRepository.class);
    private HashMap<String, ToolRuntime> runtimes = new HashMap();

    public RuntimeRepository(File workDir, InputStream runtimeConfig) throws CompException {
        this.loadRuntimes(workDir, runtimeConfig);
    }

    public ToolRuntime getRuntime(String name) {
        return this.runtimes.get(name);
    }

    private synchronized void loadRuntimes(File workDir, InputStream runtimeConfig) throws CompException {
        logger.info((Object)"loading runtimes");
        try {
            Document document = XmlUtil.parseReader(new InputStreamReader(runtimeConfig));
            Element runtimesElement = (Element)document.getElementsByTagName("runtimes").item(0);
            for (Element runtimeElement : XmlUtil.getChildElements(runtimesElement, "runtime")) {
                String runtimeName = XmlUtil.getChildElement(runtimeElement, "name").getTextContent().trim();
                logger.info((Object)("loading runtime " + runtimeName));
                if (this.runtimes.containsKey(runtimeName)) {
                    logger.warn((Object)("runtime with the same name " + runtimeName + " already loaded, keeping the first one"));
                    continue;
                }
                boolean runtimeDisabled = runtimeElement.getAttribute("disabled").equals("true");
                if (runtimeDisabled) {
                    logger.info((Object)("runtime " + runtimeName + " disabled by config"));
                }
                Element handlerElement = XmlUtil.getChildElement(runtimeElement, "handler");
                String handlerClassName = XmlUtil.getChildElement(handlerElement, "class").getTextContent().trim();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("workDir", workDir.toString());
                parameters.put("toolDir", RuntimeUtils.getToolDirFromRuntimeName(runtimeName));
                for (Element parameterElement : XmlUtil.getChildElements(handlerElement, "parameter")) {
                    String paramName = XmlUtil.getChildElement(parameterElement, "name").getTextContent().trim();
                    String paramValue = XmlUtil.getChildElement(parameterElement, "value").getTextContent().trim();
                    parameters.put(paramName, paramValue);
                }
                JobFactory jobFactory = (JobFactory)Class.forName(handlerClassName).getConstructor(HashMap.class).newInstance(parameters);
                if (jobFactory.isDisabled()) {
                    runtimeDisabled = true;
                    logger.info((Object)("runtime " + runtimeName + " disabled as handler is disabled"));
                }
                ToolRuntime runtime = new ToolRuntime(runtimeName, jobFactory, runtimeDisabled);
                this.runtimes.put(runtimeName, runtime);
            }
        }
        catch (Exception e) {
            throw new CompException(e);
        }
    }
}

