/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class Line
extends Drawable {
    private static final int COLOR_MARKER_WIDTH = 8;
    private int thickness = 1;

    public Line(double x1, double y1, double z1, double x2, double y2, double z2, Color color) {
        this.visualisationCoords = new double[2][3];
        this.projectedCoords = new double[2][2];
        this.deviceCoords = new int[2][2];
        this.dataCoords = new double[2][3];
        this.distanceFromCamera = new double[2];
        double d = x1;
        this.visualisationCoords[0][0] = d;
        this.dataCoords[0][0] = d;
        double d2 = y1;
        this.visualisationCoords[0][1] = d2;
        this.dataCoords[0][1] = d2;
        double d3 = z1;
        this.visualisationCoords[0][2] = d3;
        this.dataCoords[0][2] = d3;
        double d4 = x2;
        this.visualisationCoords[1][0] = d4;
        this.dataCoords[1][0] = d4;
        double d5 = y2;
        this.visualisationCoords[1][1] = d5;
        this.dataCoords[1][1] = d5;
        double d6 = z2;
        this.visualisationCoords[1][2] = d6;
        this.dataCoords[1][2] = d6;
        this.color = color;
    }

    public Line(double x1, double y1, double z1, double x2, double y2, double z2, Color lineColor, int thickness) {
        this(x1, y1, z1, x2, y2, z2, lineColor);
        this.thickness = thickness;
    }

    @Override
    public void draw(Graphics g, int width, int height, CoordinateArea.PaintMode notUsed) {
        if (Math.abs(this.projectedCoords[0][0]) > 1.5 || Math.abs(this.projectedCoords[0][1]) > 1.5 || this.hidden) {
            return;
        }
        g.setColor(this.color);
        this.deviceCoords[0][0] = (int)((this.projectedCoords[0][0] + 0.5) * (double)width);
        this.deviceCoords[0][1] = (int)((this.projectedCoords[0][1] + 0.5) * (double)height);
        this.deviceCoords[1][0] = (int)((this.projectedCoords[1][0] + 0.5) * (double)width);
        this.deviceCoords[1][1] = (int)((this.projectedCoords[1][1] + 0.5) * (double)height);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(this.thickness));
        g2.drawLine(this.deviceCoords[0][0], this.deviceCoords[0][1], this.deviceCoords[1][0], this.deviceCoords[1][1]);
    }

    @Override
    public void setDistanceFromCamera(double[] camera, double planeDistance, double viewWindowWidth, double viewWindowHeight) {
        this.distanceFromCamera[0] = DataPoint.pointDistance(camera, this.visualisationCoords[0]);
        this.distanceFromCamera[1] = DataPoint.pointDistance(camera, this.visualisationCoords[1]);
    }
}

