/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.SynonymReplace;
import java.util.LinkedList;
import java.util.List;

public class ChromosomeNameUnnormaliser {
    private String prefix;
    private String postfix;
    private SynonymReplace synonymReplace = new SynonymReplace();

    public static ChromosomeNameUnnormaliser newIdentityPreversingUnnormaliser() {
        return new ChromosomeNameUnnormaliser("", "");
    }

    private ChromosomeNameUnnormaliser(String prefix, String postfix) {
        this.prefix = prefix;
        this.postfix = postfix;
    }

    public ChromosomeNameUnnormaliser(String unnormalisedName) {
        String normalisedName = Chromosome.normalise(unnormalisedName, false);
        int matchStarts = unnormalisedName.indexOf(normalisedName);
        this.prefix = unnormalisedName.substring(0, matchStarts);
        this.postfix = unnormalisedName.substring(matchStarts + normalisedName.length());
    }

    public ChromosomeNameUnnormaliser(List<String> unnormalisedNames) {
        String prefixCandidate = Chromosome.getPrefix(unnormalisedNames.get(0));
        String postfixCandidate = Chromosome.getPostfix(unnormalisedNames.get(0));
        for (String name : unnormalisedNames) {
            if (!prefixCandidate.equals(Chromosome.getPrefix(name))) {
                prefixCandidate = "";
            }
            if (postfixCandidate.equals(Chromosome.getPostfix(name))) continue;
            postfixCandidate = "";
        }
        this.prefix = prefixCandidate;
        this.postfix = postfixCandidate;
        LinkedList<String> normalisedNames = new LinkedList<String>();
        for (String unnormalised : unnormalisedNames) {
            normalisedNames.add(Chromosome.normalise(unnormalised, false));
        }
        for (SynonymReplace.Synonym synonym : Chromosome.getSynonymReplace().getSynonyms()) {
            if (normalisedNames.contains(synonym.getReplaceWith()) || !normalisedNames.contains(synonym.getSearchFor())) continue;
            this.synonymReplace.add(new SynonymReplace.Synonym(synonym.getReplaceWith(), synonym.getSearchFor()));
        }
    }

    public String unnormalise(Chromosome normalised) {
        return this.unnormalise(normalised.toNormalisedString());
    }

    public String unnormalise(String normalised) {
        normalised = this.synonymReplace.apply(normalised);
        return this.prefix + normalised + this.postfix;
    }
}

