/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BaseStorage {
    private static final int MIN_SIGNIFICANT_SNP_COUNT = 2;
    private static final double MIN_SIGNIFICANT_SNP_RATIO = 0.2;
    private TreeMap<Long, Base> collector = new TreeMap();

    public void addNucleotideCounts(ReadPart readPart) {
        if (!readPart.isVisible()) {
            return;
        }
        Base base = null;
        String seq = readPart.getSequencePart();
        for (int j = 0; j < seq.length(); ++j) {
            Long bp = readPart.start.bp + (long)j;
            if (!this.collector.containsKey(bp)) {
                base = new Base(bp, null);
                this.collector.put(bp, base);
            } else {
                base = this.collector.get(bp);
            }
            Nucleotide nucleotide = Nucleotide.fromCharacter(seq.charAt(j));
            if (nucleotide == null) continue;
            base.addNucleotidee(nucleotide);
        }
    }

    public Iterator<Base> iterator() {
        return this.collector.values().iterator();
    }

    public void filter(Region filterRegion) {
        Iterator<Map.Entry<Long, Base>> iterator = this.collector.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Base> entry = iterator.next();
            if (filterRegion.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    public static class Base {
        private int[] nucleutideCounts = new int[Nucleotide.values().length];
        private Long bpLocation;
        private int[] snpCounts = null;
        private int totalSNPCount = 0;
        private int totalCount = 0;
        private Nucleotide referenceNt;

        public Base(Long bpLocation, Nucleotide referenceNt) {
            this.bpLocation = bpLocation;
            this.referenceNt = referenceNt;
        }

        public Long getBpLocation() {
            return this.bpLocation;
        }

        public int getCoverage() {
            return this.totalCount;
        }

        public boolean hasSignificantSNPs() {
            int[] snpCounts = this.getSNPCounts();
            for (Nucleotide nt : Nucleotide.values()) {
                if (snpCounts[nt.ordinal()] < 2 || !((double)snpCounts[nt.ordinal()] / (double)this.totalCount >= 0.2)) continue;
                return true;
            }
            return false;
        }

        public int[] getNucleotideCounts() {
            return this.nucleutideCounts;
        }

        public void addNucleotidee(Nucleotide nt) {
            if (this.snpCounts != null) {
                throw new IllegalStateException("cannot add nucleotides after SNP counts have been calculated");
            }
            int n = nt.ordinal();
            this.nucleutideCounts[n] = this.nucleutideCounts[n] + 1;
            ++this.totalCount;
        }

        public int getTotalSNPCount() {
            if (this.snpCounts == null) {
                throw new IllegalStateException("cannot get total before calling getSNPCounts()");
            }
            return this.totalSNPCount;
        }

        public Nucleotide getReferenceNucleotide() {
            return this.referenceNt;
        }

        public int[] getSNPCounts() {
            if (this.snpCounts == null) {
                this.snpCounts = new int[Nucleotide.values().length];
                if (this.referenceNt != null) {
                    for (Nucleotide nt : Nucleotide.values()) {
                        if (nt.compareTo(this.referenceNt) == 0) {
                            this.snpCounts[nt.ordinal()] = 0;
                            continue;
                        }
                        this.snpCounts[nt.ordinal()] = this.nucleutideCounts[nt.ordinal()];
                        this.totalSNPCount += this.nucleutideCounts[nt.ordinal()];
                    }
                }
            }
            return this.snpCounts;
        }

        public void setNucleotideCounts(int[] nucleotideCounts) {
            this.nucleutideCounts = nucleotideCounts;
            this.totalCount = 0;
            for (int i = 0; i < nucleotideCounts.length; ++i) {
                this.totalCount += nucleotideCounts[i];
            }
        }
    }

    public static enum Nucleotide {
        A,
        C,
        G,
        T;


        public Nucleotide complement() {
            switch (this) {
                case A: {
                    return T;
                }
                case C: {
                    return G;
                }
                case G: {
                    return C;
                }
                case T: {
                    return A;
                }
            }
            throw new RuntimeException("this never happens");
        }

        public static Nucleotide fromCharacter(char character) {
            switch (Character.toUpperCase(character)) {
                case 'A': {
                    return A;
                }
                case 'C': {
                    return C;
                }
                case 'G': {
                    return G;
                }
                case 'T': {
                    return T;
                }
            }
            return null;
        }

        public static Nucleotide fromCharacter(char character, boolean complement) {
            Nucleotide nt = Nucleotide.fromCharacter(character);
            if (nt != null && complement) {
                return nt.complement();
            }
            return nt;
        }
    }
}

