/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.util.ScaleUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ScaleTrack
extends Track {
    private static final int TOP_MARGIN = 0;
    private int height;
    private float minValue;
    private float maxValue;
    private int stepCount;
    private float[] scale;
    private boolean xAxisVisible = false;

    public ScaleTrack(int height, float minValue, float maxValue, int stepCount) {
        this.height = height;
        this.minValue = minValue;
        this.stepCount = stepCount;
        this.setMaxValue(maxValue);
    }

    public ScaleTrack(int height, float minValue, float maxValue) {
        this(height, minValue, maxValue, ScaleTrack.getDefaultStepCount(height));
    }

    private static int getDefaultStepCount(int height) {
        int stepCount = 4;
        if (height < 40) {
            stepCount = 2;
        }
        return stepCount;
    }

    public ScaleTrack(int height, int stepCount) {
        this(height, 0.0f, 100.0f, stepCount);
    }

    public void setXAxisVisible(boolean visible) {
        this.xAxisVisible = visible;
    }

    public List<Drawable> getScaleDrawables() {
        LinkedList<Drawable> drawables = new LinkedList<Drawable>();
        if (this.getTrackHeight() > 20) {
            Color scaleColor = Color.black;
            int CHAR_WIDTH = 6;
            int START_OFFSET = 3;
            int END_OFFSET = -13;
            int textOffset = 3;
            int maxTextWidth = 0;
            for (float scaleValue : this.scale) {
                String text = "" + ScaleUtil.format(scaleValue);
                maxTextWidth = Math.max(maxTextWidth, text.length() * 6);
            }
            int scaleX = super.getVisibleWidth() - maxTextWidth - 4;
            for (float scaleValue : this.scale) {
                int lineY = this.getScaledY(scaleValue);
                int textY = this.getScaledY(scaleValue) + 6;
                int lineX2 = scaleX - 6;
                String text = "" + ScaleUtil.format(scaleValue);
                if (this.xAxisVisible && scaleValue == 0.0f) {
                    lineX2 = 0;
                }
                drawables.add(new LineDrawable(scaleX, lineY, lineX2, lineY, scaleColor));
                drawables.add(new TextDrawable(scaleX + 4, textY + textOffset, text, scaleColor));
                textOffset -= 16 / this.scale.length;
            }
            drawables.add(new LineDrawable(scaleX, this.getScaledY(this.minValue), scaleX, this.getScaledY(this.maxValue), scaleColor));
        }
        return drawables;
    }

    public int getScaledY(float value) {
        return (int)((value - this.minValue) / (this.maxValue - this.minValue) * (float)(this.height - 0 - 2) + 1.0f);
    }

    @Override
    public int getTrackHeight() {
        return this.height;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.scale = ScaleUtil.generateScaleValues(this.minValue, maxValue, this.stepCount);
        this.minValue = this.scale[0];
        this.maxValue = this.scale[this.stepCount - 1];
    }

    public Integer getMaxY(Collection<Drawable> drawables) {
        int maxY = 0;
        for (Drawable drawable : drawables) {
            maxY = Math.max(drawable.getMaxY() + 1, maxY);
        }
        return maxY;
    }

    public int getMaxTotalCoverage() {
        return (int)this.maxValue;
    }

    public void updateScale() {
        this.setMaxValue(this.view.parentPlot.getReadScale().numReads.intValue());
    }

    @Override
    public void updateLayout() {
        if (this.view.parentPlot.getReadScale() == GBrowserPlot.ReadScale.AUTO) {
            this.view.parentPlot.getReadScale().set(this.getMaxTotalCoverage());
        }
    }
}

