/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CnaTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScatterplotTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import java.awt.Color;
import java.util.LinkedList;

public class CnaLogRatiosTrackGroup
extends CnaTrackGroup {
    public CnaLogRatiosTrackGroup(GBrowserView view, CnaConversion dataThread, LinkedList<String> sampleNames, String title) {
        super(view, dataThread, sampleNames, title + " log ratios", true);
    }

    @Override
    public void addTracks() {
        super.addTracks();
        if (!this.isMinimized()) {
            for (int i = 0; i < this.sampleNames.size(); ++i) {
                String name = (String)this.sampleNames.get(i);
                this.addLogRatioTrack(name, i);
            }
        }
    }

    private void addLogRatioTrack(String name, int i) {
        TitleTrack title = new TitleTrack(name, Color.black, GBrowserConstants.SCATTERPLOT_TITLE_COLOR);
        title.setView(this.view);
        this.addTrack(title);
        ScatterplotTrack logRatio = new ScatterplotTrack(GBrowserConstants.BED_COLOR, 24, -1.0f, 1.0f, i, 0, Long.MAX_VALUE);
        logRatio.setView(this.view);
        logRatio.addDataThread(this.dataThread);
        this.addTrack(logRatio);
    }
}

