/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.BrowserSelectionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class SelectionManager {
    HashMap<DataUrl, SelectableSet> selection = new HashMap();
    private HashMap<DataUrl, RowSet> rowSelection = new HashMap();
    private LinkedList<BrowserSelectionListener> listeners = new LinkedList();
    private GBrowser browser;

    public SelectionManager(GBrowser browser) {
        this.browser = browser;
    }

    private void add(DataUrl data, Selectable selectable, Object eventSource) {
        boolean added = this.getSelectableSet(data).add(selectable);
        if (added) {
            this.callSelectionListeners(data, selectable, eventSource);
        }
    }

    public SelectableSet getSelectableSet(DataUrl data) {
        if (!this.selection.containsKey(data)) {
            this.selection.put(data, new SelectableSet());
        }
        return this.selection.get(data);
    }

    private RowSet getRowSet(DataUrl data) {
        if (!this.rowSelection.containsKey(data)) {
            this.rowSelection.put(data, new RowSet());
        }
        return this.rowSelection.get(data);
    }

    public boolean isSelected(DataUrl data, Selectable selectable) {
        Integer row;
        if (data == null) {
            return false;
        }
        SelectableSet set = this.getSelectableSet(data);
        boolean internal = set.contains(selectable);
        boolean external = false;
        if (selectable.getIndexKey() != null && selectable.getIndexKey().getRowNumber() != null && (external = (row = Integer.valueOf(selectable.getIndexKey().getRowNumber())) != null && this.rowSelection.containsKey(data) ? this.rowSelection.get(data).contains(row) : false) && !internal) {
            Object eventSource = this.getRowSet(data).getEventSource();
            this.add(data, selectable, eventSource);
            this.getRowSet(data).remove(row);
        }
        return internal || external;
    }

    public void set(DataUrl data, Selectable selectable) {
        this.getSelectableSet(data).clear();
        this.getRowSet(data).clear();
        if (selectable != null) {
            this.add(data, selectable, this.browser);
        } else {
            this.callSelectionListeners(data, null, this.browser);
        }
    }

    private void callSelectionListeners(DataUrl data, Selectable selectable, Object source) {
        for (BrowserSelectionListener listener : this.listeners) {
            listener.selectionChanged(data, selectable, source);
        }
    }

    public void addSelectionListener(BrowserSelectionListener listener) {
        this.listeners.add(listener);
    }

    public String getSelectionText() {
        StringBuilder builder = new StringBuilder();
        LinkedList<DataUrl> datasIntrackOrder = new LinkedList<DataUrl>();
        for (Track track : this.browser.getPlot().getDataView().getTracks()) {
            DataUrl data = track.getDataUrl();
            if (data == null || datasIntrackOrder.contains(data)) continue;
            datasIntrackOrder.add(data);
        }
        for (DataUrl data : datasIntrackOrder) {
            SelectableSet set = this.selection.get(data);
            if (set == null) continue;
            for (Selectable item : this.selection.get(data)) {
                builder.append(item.getText());
                builder.append("\n\n");
            }
        }
        return builder.toString();
    }

    public void toggle(DataUrl data, Selectable selectable) {
        SelectableSet set = this.getSelectableSet(data);
        if (set.contains(selectable)) {
            this.remove(data, selectable, this.browser);
        } else {
            this.add(data, selectable, this.browser);
        }
    }

    private void remove(DataUrl data, Selectable selectable, Object eventSource) {
        boolean removed = this.getSelectableSet(data).remove(selectable);
        if (removed) {
            this.callSelectionListeners(data, selectable, eventSource);
        }
    }

    public Set<DataUrl> getDataUrls() {
        return this.selection.keySet();
    }

    public void setRowSelections(DataUrl data, HashSet<Integer> rows, Object eventSource) {
        this.getSelectableSet(data).clear();
        RowSet rowSet = this.getRowSet(data);
        rowSet.clear();
        rowSet.setEventSource(eventSource);
        rowSet.addAll(rows);
        if (this.browser.getPlot() != null) {
            this.browser.getPlot().redraw();
        }
    }

    public class RowSet
    extends HashSet<Integer> {
        private Object source;

        public void setEventSource(Object source) {
            this.source = source;
        }

        public Object getEventSource() {
            return this.source;
        }
    }

    public class SelectableSet
    extends HashSet<Selectable> {
    }
}

