/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.session.SessionLoaderImpl1;
import fi.csc.microarray.client.session.SessionLoaderImpl2;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.XmlUtil;
import fi.csc.microarray.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SessionLoader {
    private DataManager dataManager;
    private File sessionFile;
    private String sessionId;
    private boolean isDatalessSession;
    private Integer xOffset;
    private String sessionNotes;
    private List<OperationRecord> unfinishedJobs;

    public SessionLoader(File sessionFile, boolean isDatalessSession, DataManager dataManager) throws MicroarrayException {
        this.sessionFile = sessionFile;
        this.sessionId = null;
        this.dataManager = dataManager;
        this.isDatalessSession = isDatalessSession;
    }

    public SessionLoader(String sessionId, DataManager dataManager) throws MicroarrayException {
        this.sessionFile = null;
        this.sessionId = sessionId;
        this.dataManager = dataManager;
        this.isDatalessSession = true;
    }

    public void loadSession() throws Exception {
        ZipFile zipFile = null;
        String version = Integer.toString(UserSession.SESSION_VERSION);
        try {
            if (this.sessionFile != null) {
                zipFile = new ZipFile(this.sessionFile);
                version = SessionLoader.getSessionVersion(zipFile.getInputStream(zipFile.getEntry("session.xml")));
            }
        }
        finally {
            ZipUtils.closeIfPossible(zipFile);
        }
        if (Integer.toString(UserSession.PREVIOUS_SESSION_VERSION).equals(version)) {
            SessionLoaderImpl1 impl = new SessionLoaderImpl1(this.sessionFile, this.dataManager, this.isDatalessSession);
            impl.loadSession();
            return;
        }
        SessionLoaderImpl2 impl = this.sessionFile != null ? new SessionLoaderImpl2(this.sessionFile, this.dataManager, this.isDatalessSession) : new SessionLoaderImpl2(this.sessionId, this.dataManager, this.isDatalessSession);
        impl.setXOffset(this.xOffset);
        impl.loadSession();
        this.sessionNotes = impl.getSessionNotes();
        this.unfinishedJobs = impl.getUnfinishedOperations();
    }

    public static String getSessionVersion(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        try (InputStreamReader metadataReader = new InputStreamReader(inputStream);){
            Document doc = XmlUtil.parseReader(metadataReader);
            String string = doc.getDocumentElement().getAttribute("format-version");
            return string;
        }
    }

    public void setXOffset(Integer xOffset) {
        this.xOffset = xOffset;
    }

    public String getSessionNotes() {
        return this.sessionNotes;
    }

    public List<OperationRecord> getUnifinishedJobs() {
        return this.unfinishedJobs;
    }
}

