/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolPanel;
import fi.csc.microarray.client.operation.ToolSelectorPanel;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ToolFilterPanel
extends JPanel
implements ListSelectionListener {
    private static final ToolCategory CATEGORY_ALL = new ToolCategory("All");
    private ToolCategory CATEGORY_NO_MATCHES = new ToolCategory("No matches");
    private ToolPanel toolPanel;
    private List<ToolCategory> categories;
    private List<OperationDefinition> matchingOperations = new LinkedList<OperationDefinition>();
    private JList categoryList;
    private JList visibleOperationsList;
    private ExecutionItem selectedTool;

    public ToolFilterPanel(ToolPanel parent, List<ToolCategory> categories) {
        super(new GridLayout(1, 2));
        this.toolPanel = parent;
        this.categories = categories;
        this.categoryList = new JList();
        this.categoryList.setSelectedIndex(0);
        this.categoryList.setSelectionMode(0);
        this.categoryList.addListSelectionListener(this);
        this.categoryList.setCellRenderer(new ToolSelectorPanel.CategoryListRenderer());
        this.categoryList.getInsets().right = 1;
        this.categoryList.setName("categoryList");
        this.visibleOperationsList = new JList();
        this.visibleOperationsList.setSelectionMode(0);
        this.visibleOperationsList.addListSelectionListener(this);
        this.visibleOperationsList.setCellRenderer(new ToolSelectorPanel.FontSizeFriendlyListRenderer());
        this.visibleOperationsList.getInsets().right = 1;
        this.visibleOperationsList.setName("operationList");
        JScrollPane categoryListScroller = new JScrollPane(this.categoryList);
        JScrollPane operationListScroller = new JScrollPane(this.visibleOperationsList);
        categoryListScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.TOOL_LIST_BORDER_COLOR));
        operationListScroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(categoryListScroller);
        this.add(operationListScroller);
    }

    public void loadFilteredOperations(String filterPhrase) {
        Vector<OperationDefinition> filteredOperations = new Vector<OperationDefinition>();
        LinkedList<Float> filteredOperationsWeights = new LinkedList<Float>();
        for (ToolCategory category : this.categories) {
            this.selectedTool = null;
            for (OperationDefinition operation : category.getToolList()) {
                float weightDescription;
                int indexInTitle = operation.getDisplayName().toLowerCase().indexOf(filterPhrase.toLowerCase());
                int indexInDescription = operation.getDescription().toLowerCase().indexOf(filterPhrase.toLowerCase());
                float weightTitle = (float)Math.min(indexInTitle + 1, 1) / (float)(indexInTitle + 2) / (float)operation.getDisplayName().length() * 2.0f;
                if (!(weightTitle + (weightDescription = (float)Math.min(indexInDescription + 1, 1) / (float)operation.getDescription().length()) > 0.0f)) continue;
                filteredOperations.add(operation);
                filteredOperationsWeights.add(Float.valueOf(weightTitle + weightDescription));
            }
        }
        class OperationFilterComparator
        implements Comparator<OperationDefinition> {
            Vector<OperationDefinition> operations;
            LinkedList<Float> weights;

            public OperationFilterComparator(Vector<OperationDefinition> filteredOperations, LinkedList<Float> filteredOperationsWeights) {
                this.operations = new Vector<OperationDefinition>(filteredOperations);
                this.weights = filteredOperationsWeights;
            }

            @Override
            public int compare(OperationDefinition o1, OperationDefinition o2) {
                float weight1 = this.weights.get(this.operations.indexOf(o1)).floatValue();
                float weight2 = this.weights.get(this.operations.indexOf(o2)).floatValue();
                return Math.round(Math.signum(weight2 - weight1));
            }
        }
        Collections.sort(filteredOperations, new OperationFilterComparator(filteredOperations, filteredOperationsWeights));
        LinkedList<ToolCategory> matchingCategories = new LinkedList<ToolCategory>();
        for (OperationDefinition filteredDefinition : filteredOperations) {
            ToolCategory oc = filteredDefinition.getCategory();
            if (matchingCategories.contains(oc)) continue;
            matchingCategories.add(oc);
        }
        Collections.sort(matchingCategories, new Comparator<ToolCategory>(){

            @Override
            public int compare(ToolCategory category1, ToolCategory category2) {
                return ToolFilterPanel.this.categories.indexOf(category1) - ToolFilterPanel.this.categories.indexOf(category2);
            }
        });
        if (filteredOperations.size() > 0) {
            matchingCategories.addFirst(CATEGORY_ALL);
        } else {
            this.CATEGORY_NO_MATCHES.setName("No matching tools for '" + filterPhrase + "'");
            matchingCategories.addFirst(this.CATEGORY_NO_MATCHES);
        }
        this.categoryList.setListData(matchingCategories.toArray());
        this.matchingOperations = filteredOperations;
        this.visibleOperationsList.setListData(filteredOperations);
        if (!filteredOperations.isEmpty()) {
            this.visibleOperationsList.setSelectedValue(filteredOperations.firstElement(), true);
        } else {
            this.toolPanel.highlightTab(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        Object selected;
        if (event.getSource() == this.categoryList && this.categoryList.getSelectedValue() != null) {
            ToolCategory selectedCategory = (ToolCategory)this.categoryList.getSelectedValue();
            List<Object> matchingToolsInSelectedCategory = new LinkedList();
            if (selectedCategory == this.CATEGORY_NO_MATCHES) {
                this.categoryList.clearSelection();
                return;
            }
            if (selectedCategory == CATEGORY_ALL) {
                matchingToolsInSelectedCategory = this.matchingOperations;
            } else {
                for (OperationDefinition tool : this.matchingOperations) {
                    if (!tool.getCategory().equals(selectedCategory)) continue;
                    matchingToolsInSelectedCategory.add(tool);
                }
            }
            this.visibleOperationsList.setListData(matchingToolsInSelectedCategory.toArray());
            if (!matchingToolsInSelectedCategory.isEmpty()) {
                this.visibleOperationsList.setSelectedValue(matchingToolsInSelectedCategory.get(0), true);
            }
        } else if (event.getSource() == this.visibleOperationsList && (selected = this.visibleOperationsList.getSelectedValue()) instanceof ExecutionItem) {
            this.selectedTool = (ExecutionItem)selected;
            this.toolPanel.selectTool(this.selectedTool);
            ToolCategory category = ((OperationDefinition)selected).getCategory();
            this.categoryList.removeListSelectionListener(this);
            this.categoryList.setSelectedValue(category, true);
            this.categoryList.addListSelectionListener(this);
            this.toolPanel.highlightTab(category.getModule().getModuleName());
        }
    }

    public ExecutionItem getSelectedTool() {
        return this.selectedTool;
    }
}

