/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataviews.vertexes;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataview.MicroarrayGraph;
import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GraphVertex;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class GroupVertex
extends AbstractGraphVertex {
    private ClientApplication application = Session.getSession().getApplication();

    public GroupVertex(int x, int y, GraphVertex[] children, MicroarrayGraph graph) {
        super(x, y, null, graph);
        this.addPort();
        graph.getGraphLayoutCache().toBack(new Object[]{this});
        if (children != null) {
            for (GraphVertex vertex : children) {
                this.addChildVertex(vertex);
            }
        }
        graph.repaint();
    }

    public void collapse() {
        this.getGraph().getGraphLayoutCache().collapse(new Object[]{this});
        this.getGraph().updateSelectedCells();
    }

    public void expand() {
        this.getGraph().getGraphLayoutCache().expand(new Object[]{this});
        this.getGraph().updateSelectedCells();
    }

    public List<AbstractGraphVertex> getChildVertexes() {
        ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof AbstractGraphVertex)) continue;
            vertexes.add((AbstractGraphVertex)((Object)child));
        }
        return vertexes;
    }

    public List<DataBean> getChildrenData() {
        ArrayList<DataBean> childData = new ArrayList<DataBean>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof GraphVertex)) continue;
            GraphVertex vertex = (GraphVertex)((Object)child);
            assert (vertex.getData() instanceof DataBean);
            childData.add(vertex.getData());
        }
        return childData;
    }

    @Override
    public String toString() {
        int childCount = this.getChildCount() - 1;
        if (childCount > 1) {
            return "" + childCount;
        }
        return "" + childCount;
    }

    @Override
    public String getToolTipString() {
        return this.toString();
    }

    public boolean isSelectable() {
        return (Boolean)this.getAttributes().get((Object)"selectable");
    }

    @Override
    public void addChildVertex(GraphVertex vertex) {
        this.expand();
        vertex.setPosition(new Point((int)this.getBounds().getX(), (int)this.getBounds().getY()));
        this.add((MutableTreeNode)((Object)vertex));
        this.collapse();
    }

    @Override
    public void setPosition(Point p) {
        for (AbstractGraphVertex child : this.getChildVertexes()) {
            child.setPosition(p);
        }
        super.setPosition(p);
    }

    public boolean isAllChildrenSelected() {
        List<DataBean> selectedDatas = this.application.getSelectionManager().getSelectedDataBeans();
        if (selectedDatas.size() == 0) {
            return false;
        }
        for (DataBean childData : this.getChildrenData()) {
            if (selectedDatas.contains(childData)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeChildVertex(GraphVertex vertex) {
        if (!this.contains(vertex)) {
            return false;
        }
        this.expand();
        if (this.getChildVertexes().size() == 0) {
            this.getGraph().getGraphLayoutCache().remove(new Object[]{this});
        }
        this.collapse();
        return true;
    }

    public boolean contains(GraphVertex vertex) {
        return ((Object)((Object)vertex.getGroup())).equals((Object)this);
    }

    @Override
    public int getDefaultHeight() {
        return 21;
    }

    @Override
    public int getDefaultWidth() {
        return 40;
    }
}

