/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.tools;

import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.tools.ToolsInternalFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jdesktop.swingx.JXTaskPane;

public class ChipCountPanel
extends JXTaskPane
implements ActionListener {
    private JCheckBox[] keyColumnCheckBoxes;
    private JLabel[] keyColumnCounterLabels;
    private JLabel[] keyColumnTotalCountLabels;
    private JLabel firstRowLabel;
    private ImportScreen screen;
    protected static final ColumnType[] KEYS = new ColumnType[]{ColumnType.SAMPLE_LABEL, ColumnType.SAMPLE_BG_LABEL, ColumnType.CONTROL_LABEL, ColumnType.CONTROL_BG_LABEL, ColumnType.FLAG_LABEL, ColumnType.IDENTIFIER_LABEL, ColumnType.ANNOTATION_LABEL};

    public static boolean isCountedKey(ColumnType key) {
        for (int i = 0; i < KEYS.length; ++i) {
            if (!KEYS[i].equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public ChipCountPanel(ImportScreen screen) {
        ToolsInternalFrame.setUpTaskPane(this);
        this.setLayout(new GridBagLayout());
        this.screen = screen;
        this.keyColumnCheckBoxes = new JCheckBox[KEYS.length];
        this.keyColumnCounterLabels = new JLabel[KEYS.length];
        this.keyColumnTotalCountLabels = new JLabel[KEYS.length];
        for (int i = 0; i < KEYS.length; ++i) {
            if (i == 0) {
                this.keyColumnCheckBoxes[i] = new JCheckBox();
                this.keyColumnCheckBoxes[i].setPreferredSize(new Dimension(17, 19));
                this.keyColumnCheckBoxes[i].setSelected(true);
                this.keyColumnCheckBoxes[i].setEnabled(false);
            } else {
                this.keyColumnCheckBoxes[i] = new JCheckBox(KEYS[i].toString());
                this.keyColumnCheckBoxes[i].setSelected(true);
                this.keyColumnCheckBoxes[i].setActionCommand(KEYS[i].toString());
                this.keyColumnCheckBoxes[i].addActionListener(this);
            }
            this.keyColumnCounterLabels[i] = new JLabel("0");
            this.keyColumnCounterLabels[i].setOpaque(true);
            this.keyColumnTotalCountLabels[i] = new JLabel(" of 1");
            this.keyColumnTotalCountLabels[i].setOpaque(true);
            Color rowBg = Color.white;
            this.keyColumnCheckBoxes[i].setBackground(rowBg);
            this.keyColumnCounterLabels[i].setBackground(rowBg);
            this.keyColumnTotalCountLabels[i].setBackground(rowBg);
        }
        this.firstRowLabel = new JLabel(KEYS[0].toString());
        this.firstRowLabel.setOpaque(true);
        this.firstRowLabel.setBackground(Color.white);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        for (int i = 0; i < KEYS.length; ++i) {
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 17;
            if (i == 0) {
                c.weightx = 0.0;
                c.gridwidth = 1;
                this.add(this.keyColumnCheckBoxes[0], c);
                c.gridx = 1;
                c.weightx = 1.0;
                c.gridwidth = 2;
                this.add(this.firstRowLabel, c);
            } else {
                c.gridwidth = 3;
                this.add(this.keyColumnCheckBoxes[i], c);
            }
            c.gridx = 3;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 13;
            this.add(this.keyColumnCounterLabels[i], c);
            c.gridx = 4;
            this.add(this.keyColumnTotalCountLabels[i], c);
        }
        this.setTitle("Channels");
        this.setCollapsed(true);
    }

    public void updateKeyColumnCounter(int keyNumber) {
        int countOfProperlySetKeys = this.screen.getColumnTypeManager().getCountOfCorrectlySet(KEYS[keyNumber]);
        int countOfKeys = this.screen.getColumnTypeManager().getCountOfType(KEYS[keyNumber]);
        this.keyColumnCounterLabels[keyNumber].setText("" + countOfKeys);
        if (this.keyColumnCheckBoxes[keyNumber].isSelected()) {
            if (KEYS[keyNumber].equals((Object)ColumnType.IDENTIFIER_LABEL)) {
                this.keyColumnTotalCountLabels[keyNumber].setText(" of 1");
            } else if (KEYS[keyNumber].equals((Object)ColumnType.ANNOTATION_LABEL)) {
                this.keyColumnTotalCountLabels[keyNumber].setText("");
            } else {
                this.keyColumnTotalCountLabels[keyNumber].setText(" of " + this.screen.getColumnTypeManager().getCountOfType(ColumnType.SAMPLE_LABEL));
            }
        } else {
            this.keyColumnTotalCountLabels[keyNumber].setText(" of 0");
        }
        int sampleCount = this.screen.getColumnTypeManager().getCountOfType(ColumnType.SAMPLE_LABEL);
        if (KEYS[keyNumber].equals((Object)ColumnType.ANNOTATION_LABEL)) {
            this.keyColumnCounterLabels[keyNumber].setForeground(Color.BLACK);
            this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.BLACK);
        } else if (KEYS[keyNumber].equals((Object)ColumnType.IDENTIFIER_LABEL)) {
            if (countOfKeys > 1 || countOfKeys > sampleCount) {
                this.keyColumnCounterLabels[keyNumber].setForeground(Color.RED);
                this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.RED);
            } else {
                this.keyColumnCounterLabels[keyNumber].setForeground(Color.BLACK);
                this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.BLACK);
            }
        } else if (countOfProperlySetKeys == sampleCount && countOfKeys == sampleCount && sampleCount > 0) {
            this.keyColumnCounterLabels[keyNumber].setForeground(Color.GREEN.darker());
            this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.GREEN.darker());
        } else if (countOfKeys > sampleCount || countOfKeys == sampleCount && countOfProperlySetKeys < sampleCount) {
            this.keyColumnCounterLabels[keyNumber].setForeground(Color.RED);
            this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.RED);
        } else {
            this.keyColumnCounterLabels[keyNumber].setForeground(Color.BLACK);
            this.keyColumnTotalCountLabels[keyNumber].setForeground(Color.BLACK);
        }
        this.repaint();
    }

    public void updateAllKeyColumnCounters() {
        for (int i = 0; i < KEYS.length; ++i) {
            this.updateKeyColumnCounter(i);
        }
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < KEYS.length; ++i) {
            this.firstRowLabel.setEnabled(enabled);
            if (i > 0) {
                this.keyColumnCheckBoxes[i].setEnabled(enabled);
            }
            this.keyColumnCounterLabels[i].setEnabled(enabled);
            this.keyColumnTotalCountLabels[i].setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox) {
            for (int i = 0; i < this.keyColumnCheckBoxes.length; ++i) {
                if (this.keyColumnCheckBoxes[i] != source) continue;
                this.updateKeyColumnCounter(i);
                boolean isSelected = this.keyColumnCheckBoxes[i].isSelected();
                this.keyColumnCounterLabels[i].setEnabled(isSelected);
                this.keyColumnTotalCountLabels[i].setEnabled(isSelected);
                break;
            }
        }
    }
}

