/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.cli;

import fi.csc.microarray.client.cli.CliClientApplication;
import fi.csc.microarray.client.cli.UserErrorException;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.parameter.DecimalParameter;
import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.MetaColnameParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.PercentageParameter;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.auth.SimpleAuthenticationRequestListener;
import fi.csc.microarray.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.joda.time.DateTime;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CliClient {
    private static final String KEY_INPUTS = "inputs";
    private static final String KEY_NOTES = "notes";
    private static final String KEY_SIZE = "size";
    private static final String KEY_VALUE = "value";
    private static final String KEY_DATE = "date";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_TOOL = "tool";
    private static final String KEY_HELP = "help";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_NAME = "name";
    private static final String KEY_PARAM = "parameter";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_MAX = "max";
    private static final String KEY_MIN = "min";
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_TYPE = "type";
    private static final String KEY_OPTION = "option";
    private static final String KEY_INTEGER = "INTEGER";
    private static final String KEY_DECIMAL = "DECIMAL";
    private static final String KEY_PERCENT = "PERCENT";
    private static final String KEY_STRING = "STRING";
    private static final String KEY_ENUM = "ENUM";
    private static final String KEY_METACOLUMN_SEL = "METACOLUMN_SEL ";
    private static final String OPT_CONFIG = "config";
    private static final String OPT_USERNAME = "username";
    private static final String OPT_PASSWORD = "password";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_QUIET = "quiet";
    private static final String OPT_YAML = "yaml";
    private static final String OPT_WORKING_COPY = "working-copy";
    private static final String OPT_LOCAL = "local";
    private static final String OPT_CLOUD = "cloud";
    private static final String OPT_SHOW_ID = "show-id";
    private static final String CMD_INTERACTIVE = "interactive";
    private static final String CMD_EXIT = "exit";
    private static final String CMD_LIST_DATASETS = "list-datasets";
    private static final String CMD_DATASET = "dataset";
    private static final String CMD_PRINT = "print";
    private static final String CMD_HISTORY = "history";
    private static final String CMD_RENAME = "rename";
    private static final String CMD_DELETE = "delete";
    private static final String CMD_IMPORT = "import";
    private static final String CMD_EXPORT = "export";
    private static final String CMD_LIST_TOOLS = "list-tools";
    private static final String CMD_TOOL = "tool";
    private static final String CMD_RUN = "run";
    private static final String CMD_SAVE_WORKFLOW = "save-workflow";
    private static final String CMD_RUN_WORKFLOW = "run-workflow";
    private static final String ARG_SEARCH_TERM = "search-term";
    private static final String ARG_TOOL_ID = "tool-id";
    private static final String ARG_DATASET = "dataset";
    private static final String ARG_FILE = "file";
    private static final String ARG_OLD_NAME = "old-name";
    private static final String ARG_NEW_NAME = "new-name";
    private static final String ARG_PARAMETER = "parameter";
    private static final String ARG_SESSION = "session";
    private static final String CMD_OPEN_SESSION = "open-session";
    private static final String CMD_SAVE_SESSION = "save-session";
    private static final String CMD_LIST_SESSIONS = "list-sessions";
    private static final String CMD_DELETE_SESSION = "delete-session";
    private static final String CMD_CLEAR_SESSION = "clear-session";
    private static final String DEFAULT_WORKING_COPY = "cli-working-copy.zip";
    private Namespace nameSpace;
    private CliClientApplication app;
    private String[] args;
    private ArgumentParser parser;

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        new CliClient(args).runCliClient();
    }

    public CliClient(String[] args) {
        this.args = args;
    }

    private void runCliClient() throws InvocationTargetException, InterruptedException {
        int exitValue = 1;
        try {
            this.parse();
            exitValue = 0;
        }
        catch (UserErrorException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeAndWait(new ShutdownRunnable(exitValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws JMSException, Exception {
        this.parser = ArgumentParsers.newArgumentParser((String)"Chipster command line client", (boolean)true, (String)"-", (String)"@");
        this.addStringOption(this.parser, "-c", OPT_CONFIG, "chipster client configuration file");
        this.addStringOption(this.parser, "-u", OPT_USERNAME, "chipster username");
        this.addStringOption(this.parser, "-p", OPT_PASSWORD, "chipster password");
        this.addStringOption(this.parser, "-W", OPT_WORKING_COPY, "name of the working copy session, either zip or cloud session").setDefault((Object)DEFAULT_WORKING_COPY);
        this.addBooleanOption(this.parser, "-v", OPT_VERBOSE, "more verbose output");
        this.addBooleanOption(this.parser, "-q", OPT_QUIET, "uppress status messages and print only requested data");
        this.addBooleanOption(this.parser, "-y", OPT_YAML, "output in yaml format for programmatical access");
        Subparsers subparsers = this.parser.addSubparsers();
        subparsers.title("commands");
        this.addCommand(subparsers, CMD_LIST_DATASETS, "list datasets");
        this.addCommand(subparsers, "dataset", "view dataset details", "dataset");
        this.addCommand(subparsers, CMD_PRINT, "output dataset contents", "dataset");
        this.addCommand(subparsers, CMD_HISTORY, "view history, set verbose to view also source codes", "dataset");
        this.addCommand(subparsers, CMD_RENAME, "rename dataset", ARG_OLD_NAME).addArgument(new String[]{ARG_NEW_NAME});
        this.addCommand(subparsers, CMD_DELETE, "delete dataset", "dataset");
        this.addCommand(subparsers, CMD_IMPORT, "import file", ARG_FILE);
        this.addCommand(subparsers, CMD_EXPORT, "export dataset to file", "dataset");
        this.addCommand(subparsers, CMD_LIST_TOOLS, "list tools, search term is optional").addArgument(new String[]{ARG_SEARCH_TERM}).nargs("?");
        this.addCommand(subparsers, "tool", "show tool details, set verbose to view parameter help texts.", ARG_TOOL_ID);
        Subparser run = this.addCommand(subparsers, CMD_RUN, "run tool");
        run.addArgument(new String[]{ARG_TOOL_ID}).required(true);
        run.addArgument(new String[]{"--dataset"}).nargs("*").help("input dataset(s) for a tool");
        run.addArgument(new String[]{"--parameter"}).nargs("*").help("set parameters for a tool, e.g. parameter=VALUE");
        run.usage("run [-h] tool-id [--dataset [DATASET [DATASET ...]]] [--parameter [PARAMETER [PARAMETER ...]]]");
        Subparser saveWorkflow = this.addCommand(subparsers, CMD_SAVE_WORKFLOW, "save workflow");
        saveWorkflow.addArgument(new String[]{ARG_FILE}).help("save workflow to this file").required(true);
        saveWorkflow.addArgument(new String[]{"dataset"}).help("start saving from this dataset").required(true);
        Subparser runWorkflow = this.addCommand(subparsers, CMD_RUN_WORKFLOW, "run workflow");
        runWorkflow.addArgument(new String[]{ARG_FILE}).help("run workflow of this file").required(true);
        runWorkflow.addArgument(new String[]{"dataset"}).help("start running from this dataset").required(true);
        this.addCommand(subparsers, CMD_OPEN_SESSION, "open zip session or cloud session", ARG_SESSION, OPT_CLOUD, OPT_LOCAL);
        this.addCommand(subparsers, CMD_SAVE_SESSION, "save zip session or cloud session", ARG_SESSION, OPT_CLOUD, OPT_LOCAL, OPT_SHOW_ID);
        this.addCommand(subparsers, CMD_CLEAR_SESSION, "delete all datasets of the working copy session");
        this.addCommand(subparsers, CMD_LIST_SESSIONS, "list cloud sessions");
        this.addCommand(subparsers, CMD_DELETE_SESSION, "delete cloud session", ARG_SESSION, OPT_CLOUD, OPT_LOCAL);
        this.addCommand(subparsers, CMD_INTERACTIVE, "enter interactive mode");
        this.addCommand(subparsers, CMD_EXIT, "quit interactive mode").aliases(new String[]{"quit"});
        this.parser.epilog("use 'COMMAND -h' to show command arguments");
        try {
            this.parseArgs();
        }
        catch (HelpScreenException e) {
            return;
        }
        this.initClient();
        String workingCopy = this.openWorkingCopySession();
        if (this.isCommand(CMD_INTERACTIVE)) {
            try (Scanner scanner = new Scanner(System.in);){
                this.printlnStatus("Chipster command line client in interactive mode, type '-h' for help or 'exit' to quit");
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.parseArgs();
                        if (this.isCommand(CMD_EXIT)) {
                        }
                        this.execute();
                        this.saveWorkingCopySession(workingCopy);
                    }
                    catch (UserErrorException e) {
                        System.err.println(e.getMessage());
                    }
                    catch (HelpScreenException e) {
                        // empty catch block
                    }
                    this.printStatus(">>>");
                    String lineString = scanner.nextLine();
                    this.args = Strings.splitConsideringQuotes(lineString, ' ').toArray(new String[0]);
                }
            }
        } else {
            this.execute();
            this.saveWorkingCopySession(workingCopy);
        }
    }

    private boolean isBooleanOption(String option) {
        Boolean value = this.nameSpace.getBoolean(option);
        if (value != null) {
            return value;
        }
        return false;
    }

    private boolean isStringOption(String option) {
        return this.nameSpace.getString(option) != null;
    }

    private boolean isCommand(String cmd) {
        return this.nameSpace.getAttrs().containsKey(cmd);
    }

    private Argument addBooleanOption(ArgumentParser parser, String shortOption, String longOption, String help) {
        return this.addStringOption(parser, shortOption, longOption, help).action((ArgumentAction)new StoreTrueArgumentAction());
    }

    private Argument addStringOption(ArgumentParser parser, String shortOption, String longOption, String help) {
        return parser.addArgument(new String[]{shortOption, "--" + longOption}).dest(longOption).help(help);
    }

    private Subparser addCommand(Subparsers subparsers, String command, String help, String argument, String ... options) {
        Subparser subparser = this.addCommand(subparsers, command, help);
        subparser.addArgument(new String[]{argument});
        for (String option : options) {
            subparser.addArgument(new String[]{"--" + option}).dest(option).action((ArgumentAction)new StoreTrueArgumentAction());
        }
        return subparser;
    }

    private Subparser addCommand(Subparsers subparsers, String command, String help, String argument) {
        Subparser subparser = this.addCommand(subparsers, command, help);
        subparser.addArgument(new String[]{argument});
        return subparser;
    }

    private Subparser addCommand(Subparsers subparsers, String command, String help) {
        return subparsers.addParser(command).help(help).setDefault(command, (Object)true);
    }

    private void parseArgs() throws HelpScreenException, UserErrorException {
        try {
            this.nameSpace = this.parser.parseArgs(this.args);
        }
        catch (ArgumentParserException e) {
            if (e instanceof HelpScreenException) {
                throw (HelpScreenException)((Object)e);
            }
            throw new UserErrorException(e.getMessage());
        }
    }

    private void execute() throws JMSException, Exception {
        boolean yaml = this.isBooleanOption(OPT_YAML);
        if (this.isCommand(CMD_LIST_DATASETS)) {
            this.listDatasets(yaml);
        } else if (this.isCommand(CMD_LIST_SESSIONS)) {
            this.listSessions(yaml);
        } else if (this.isCommand(CMD_DELETE_SESSION)) {
            this.deleteSession(this.nameSpace.getString(ARG_SESSION));
        } else if (this.isCommand(CMD_PRINT)) {
            String dataset = this.nameSpace.getString("dataset");
            this.printDataset(dataset);
        } else if (this.isCommand(CMD_LIST_TOOLS)) {
            this.tools(this.nameSpace.getString(ARG_SEARCH_TERM), yaml);
        } else if (this.isCommand("tool")) {
            String tool = this.nameSpace.getString(ARG_TOOL_ID);
            this.tool(tool, yaml);
        } else if (this.isCommand(CMD_EXPORT)) {
            String dataset = this.nameSpace.getString("dataset");
            this.exportDataset(dataset);
        } else if (this.isCommand(CMD_IMPORT)) {
            String filename = this.nameSpace.getString(ARG_FILE);
            this.importDataset(filename);
        } else if (this.isCommand(CMD_RENAME)) {
            this.renameDataset(this.nameSpace.getString(ARG_OLD_NAME), this.nameSpace.getString(ARG_NEW_NAME));
        } else if (this.isCommand(CMD_RUN)) {
            String tool = this.nameSpace.getString(ARG_TOOL_ID);
            List datasets = this.nameSpace.getList("dataset");
            List parameters = this.nameSpace.getList("parameter");
            this.run(tool, datasets, parameters);
        } else if (this.isCommand(CMD_CLEAR_SESSION)) {
            this.clearSession();
        } else if (this.isCommand(CMD_SAVE_WORKFLOW)) {
            String data = this.nameSpace.getString("dataset");
            String file = this.nameSpace.getString(ARG_FILE);
            this.saveWorkflow(data, file);
        } else if (this.isCommand(CMD_RUN_WORKFLOW)) {
            String data = this.nameSpace.getString("dataset");
            String file = this.nameSpace.getString(ARG_FILE);
            this.runWorkflow(data, file);
        } else if (this.isCommand(CMD_DELETE)) {
            this.deleteDataset(this.nameSpace.getString("dataset"));
        } else if (this.isCommand(CMD_HISTORY)) {
            String dataset = this.nameSpace.getString("dataset");
            this.historyOfDataset(dataset, yaml);
        } else if (this.isCommand(CMD_OPEN_SESSION)) {
            this.openSession(this.nameSpace.getString(ARG_SESSION));
        } else if (this.isCommand(CMD_SAVE_SESSION)) {
            this.saveSession(this.nameSpace.getString(ARG_SESSION));
        } else if (this.isCommand("dataset")) {
            String dataset = this.nameSpace.getString("dataset");
            this.viewDataset(dataset, yaml);
        }
    }

    private void initClient() throws UserErrorException, IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException {
        if (!this.isStringOption(OPT_CONFIG)) {
            throw new UserErrorException("config not set");
        }
        if (!this.isStringOption(OPT_USERNAME)) {
            throw new UserErrorException("username not set");
        }
        if (!this.isStringOption(OPT_PASSWORD)) {
            throw new UserErrorException("password not set");
        }
        DirectoryLayout.initialiseClientLayout(this.nameSpace.getString(OPT_CONFIG));
        SimpleAuthenticationRequestListener auth = new SimpleAuthenticationRequestListener(this.nameSpace.getString(OPT_USERNAME), this.nameSpace.getString(OPT_PASSWORD));
        this.app = new CliClientApplication(auth, this.isBooleanOption(OPT_VERBOSE), this.isBooleanOption(OPT_QUIET));
        this.app.initialiseApplication(true);
    }

    private String openWorkingCopySession() throws UserErrorException, JMSException, Exception {
        String sessionName = this.nameSpace.getString(OPT_WORKING_COPY);
        if (this.isLocalSession(sessionName, false)) {
            File session = new File(sessionName);
            if (session.exists()) {
                this.app.getSessionManager().loadSessionAndWait(session, null, true, false, false);
            }
        } else {
            try {
                String sessionId = this.getSessionId(sessionName);
                this.app.getSessionManager().loadSessionAndWait(null, sessionId, true, false, false);
            }
            catch (UserErrorException userErrorException) {
                // empty catch block
            }
        }
        return sessionName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openSession(String sessionName) throws UserErrorException, JMSException, Exception {
        if (this.isLocalSession(sessionName, true)) {
            File session = new File(sessionName);
            if (!session.exists()) throw new UserErrorException("session not found: " + sessionName);
            this.app.getSessionManager().loadSessionAndWait(session, null, false, false, false);
            return;
        } else {
            String sessionId = this.getSessionId(sessionName);
            this.app.getSessionManager().loadSessionAndWait(null, sessionId, true, false, false);
        }
    }

    private void checkCloudConfiguration() throws UserErrorException {
        if (!this.app.getSessionManager().areCloudSessionsEnabled()) {
            throw new UserErrorException("cloud sessions are disabled on this server, use local .zip sessions instead");
        }
    }

    private void deleteSession(String sessionName) throws JMSException, Exception {
        if (this.isLocalSession(sessionName, true)) {
            File session = new File(sessionName);
            session.delete();
        } else {
            String sessionId = this.getSessionId(sessionName);
            this.app.getSessionManager().removeRemoteSession(sessionId);
        }
    }

    private void saveWorkingCopySession(String workingCopy) throws Exception {
        if (this.isLocalSession(workingCopy, false)) {
            this.app.getSessionManager().saveLightweightSession(new File(workingCopy));
        } else {
            this.saveSession(workingCopy);
        }
    }

    private void saveSession(String workingCopy) throws Exception {
        if (this.isLocalSession(workingCopy, true)) {
            this.app.getSessionManager().saveSessionAndWait(false, new File(workingCopy), null);
        } else {
            this.checkCloudConfiguration();
            this.app.getSessionManager().saveSessionAndWait(true, null, workingCopy);
            if (this.isBooleanOption(OPT_SHOW_ID)) {
                System.out.println(this.app.getSessionManager().getSessionId());
            }
        }
    }

    private boolean isLocalSession(String sessionName, boolean enableOptions) {
        if (enableOptions) {
            if (this.isBooleanOption(OPT_CLOUD)) {
                return false;
            }
            if (this.isBooleanOption(OPT_LOCAL)) {
                return true;
            }
        }
        return sessionName.endsWith(".zip");
    }

    private void listSessions(boolean yaml) throws JMSException, Exception {
        List<DbSession> sessions = this.app.getSessionManager().listRemoteSessions();
        ArrayList<String> list = new ArrayList<String>();
        for (DbSession session : sessions) {
            list.add(session.getName());
        }
        this.print(list, yaml);
    }

    private void deleteDataset(String name) throws UserErrorException {
        DataBean bean = this.getDataset(name);
        this.app.deleteDatasWithoutConfirming(bean);
    }

    private void clearSession() throws MalformedURLException, FileBrokerException, AuthCancelledException {
        this.app.getSessionManager().clearSessionWithoutConfirming();
    }

    private void saveWorkflow(String dataset, String filename) throws IOException, UserErrorException {
        DataBean bean = this.getDataset(dataset);
        this.app.getSelectionManager().selectSingle(bean, this);
        this.app.saveWorkflow(new File(filename));
    }

    private void runWorkflow(String dataset, String filename) throws IOException, UserErrorException, InterruptedException {
        DataBean bean = this.getDataset(dataset);
        this.printlnStatus("Running workflow...");
        this.app.getSelectionManager().selectSingle(bean, this);
        this.app.runWorkflowAndWait(new File(filename).toURI().toURL());
    }

    private void historyOfDataset(String dataset, boolean yaml) throws UserErrorException {
        DataBean bean = this.getDataset(dataset);
        if (yaml) {
            System.err.println("yaml output format isn't impelemented for history");
        }
        System.out.println(this.app.getHistoryText(bean, true, true, true, true, true, this.isBooleanOption(OPT_VERBOSE), true, true));
    }

    private void renameDataset(String oldName, String newName) throws UserErrorException {
        DataBean old = this.getDataset(oldName);
        this.app.renameDataItem(old, newName);
    }

    private void run(String toolId, List<String> datasets, List<String> parameters) throws MicroarrayException, UserErrorException {
        ArrayList<DataBean> inputs = new ArrayList<DataBean>();
        if (datasets != null) {
            for (String name : datasets) {
                inputs.add(this.getDataset(name));
            }
        }
        OperationDefinition tool = this.getTool(toolId);
        Operation operation = new Operation(tool, inputs.toArray(new DataBean[0]));
        if (parameters != null) {
            for (String param : parameters) {
                String[] nameAndValue = param.split("=");
                try {
                    String name = nameAndValue[0];
                    String value = nameAndValue[1];
                    Object valueObj = this.getParameterValueObject(operation.getParameter(name), value);
                    operation.setParameter(name, valueObj);
                }
                catch (Exception e) {
                    throw new UserErrorException("illegal parameter: " + param + " (" + e.toString() + ")");
                }
            }
        }
        Task task = this.app.executeOperation(operation);
        this.printStatus("Running...");
        try {
            while (this.app.getTaskExecutor().getTasks(true, true).contains(task)) {
                this.printStatus(".");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.printlnStatus("");
    }

    private void printStatus(String status) {
        if (!this.isBooleanOption(OPT_QUIET)) {
            System.out.print(status);
        }
    }

    private void printlnStatus(String status) {
        if (!this.isBooleanOption(OPT_QUIET)) {
            System.out.println(status);
        }
    }

    private Object getParameterValueObject(Parameter parameter, String value) {
        if (parameter instanceof IntegerParameter) {
            return Integer.parseInt(value);
        }
        if (parameter instanceof DecimalParameter) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (parameter instanceof PercentageParameter) {
            return Integer.parseInt(value);
        }
        if (parameter instanceof EnumParameter) {
            EnumParameter enumParam = (EnumParameter)parameter;
            for (EnumParameter.SelectionOption opt : (EnumParameter.SelectionOption[])enumParam.getOptions()) {
                if (!opt.getValue().equals(value)) continue;
                return opt;
            }
        } else {
            if (parameter instanceof StringParameter) {
                return value;
            }
            throw new IllegalArgumentException("The given Parameter object, " + parameter.getID() + ", was not of recognized type!");
        }
        return null;
    }

    private void exportDataset(String dataset) throws UserErrorException {
        DataBean source = this.getDataset(dataset);
        File destination = new File(dataset);
        this.app.exportToFileAndWait(source, destination);
    }

    private void importDataset(String filename) {
        File file = new File(filename);
        ContentType type = this.app.getDataManager().guessContentType(file);
        ImportItem item = new ImportItem(file, file.getName(), type);
        ArrayList<ImportItem> group = new ArrayList<ImportItem>();
        group.add(item);
        this.app.importGroupAndWait(group, null);
    }

    private void tool(String tool, boolean yaml) throws UserErrorException {
        OperationDefinition oper = this.getTool(tool);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tool", oper.getID());
        map.put(KEY_NAME, oper.getFullName());
        map.put(KEY_DESCRIPTION, oper.getDescription());
        map.put(KEY_HELP, oper.getHelpURL());
        ArrayList<HashMap<String, Object>> parameters = this.getParameters(oper);
        map.put(KEY_PARAMETERS, parameters);
        if (yaml) {
            this.dumpYaml(map);
        } else {
            System.out.print(StringUtils.rightPad((String)((String)map.get("tool")), (int)50));
            System.out.print(StringUtils.rightPad((String)((String)map.get(KEY_NAME)), (int)50));
            System.out.println();
            System.out.println();
            this.wrapAndPrint(map.get(KEY_DESCRIPTION).toString());
            System.out.println(map.get(KEY_HELP));
            System.out.println("PARAMETERS");
            System.out.println();
            for (HashMap<String, Object> paramMap : parameters) {
                System.out.print(this.parameterToString(paramMap));
                if (this.isBooleanOption(OPT_VERBOSE)) {
                    System.out.println();
                    this.wrapAndPrint((String)paramMap.get(KEY_DESCRIPTION));
                }
                System.out.println();
            }
        }
    }

    private void wrapAndPrint(String text) {
        String wrapped = WordUtils.wrap((String)text, (int)60);
        wrapped = "    " + wrapped.replace("\n", "\n    ");
        System.out.println(wrapped);
    }

    private ArrayList<HashMap<String, Object>> getParameters(OperationDefinition oper) {
        ArrayList<HashMap<String, Object>> parameters = new ArrayList<HashMap<String, Object>>();
        for (Parameter parameter : oper.getParameters()) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("parameter", parameter.getID());
            parameterMap.put(KEY_NAME, parameter.getDisplayName());
            parameterMap.put(KEY_DESCRIPTION, parameter.getDescription());
            HashMap<String, Object> type = this.parameterToYaml(parameter);
            parameterMap.putAll(type);
            parameters.add(parameterMap);
        }
        return parameters;
    }

    private ArrayList<HashMap<String, String>> getParameters(OperationRecord oper) {
        ArrayList<HashMap<String, String>> parameters = new ArrayList<HashMap<String, String>>();
        for (OperationRecord.ParameterRecord parameter : oper.getParameters()) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("parameter", parameter.getNameID().getID());
            parameterMap.put(KEY_NAME, parameter.getNameID().getDisplayName());
            parameterMap.put(KEY_DESCRIPTION, parameter.getNameID().getDescription());
            parameterMap.put(KEY_VALUE, parameter.getValue());
            parameters.add(parameterMap);
        }
        return parameters;
    }

    private void tools(String searchTerm, boolean yaml) {
        YamlCategory yamlCategory;
        YamlModule yamlModule;
        HashMap<String, YamlModule> yamlModules = new HashMap<String, YamlModule>();
        for (ToolModule chipsterModule : this.app.getToolModules()) {
            yamlModule = new YamlModule();
            for (ToolCategory chipsterCategory : chipsterModule.getVisibleCategories()) {
                yamlCategory = new YamlCategory();
                for (OperationDefinition chipsterTool : chipsterCategory.getToolList()) {
                    YamlTool yamlTool = new YamlTool();
                    String toolId = chipsterTool.getID();
                    String toolName = chipsterTool.getDisplayName();
                    yamlTool.put("tool", toolId);
                    yamlTool.put(KEY_NAME, toolName);
                    if (searchTerm != null && !toolId.toLowerCase().contains(searchTerm.toLowerCase()) && !toolName.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    yamlCategory.add(yamlTool);
                }
                yamlModule.put(chipsterCategory.getName(), yamlCategory);
            }
            yamlModules.put(chipsterModule.getModuleName(), yamlModule);
        }
        if (yaml) {
            this.dumpYaml(yamlModules);
        } else {
            for (String yamlModuleName : yamlModules.keySet()) {
                yamlModule = (YamlModule)yamlModules.get(yamlModuleName);
                for (String yamlCategoryName : yamlModule.keySet()) {
                    yamlCategory = (YamlCategory)yamlModule.get(yamlCategoryName);
                    for (YamlTool yamlTool : yamlCategory) {
                        System.out.print(StringUtils.rightPad((String)yamlModuleName, (int)20));
                        System.out.print(StringUtils.rightPad((String)yamlCategoryName, (int)40));
                        System.out.print(StringUtils.rightPad((String)((String)yamlTool.get("tool")), (int)50));
                        System.out.print(StringUtils.rightPad((String)((String)yamlTool.get(KEY_NAME)), (int)40));
                        System.out.println();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDataset(String dataset) throws IOException, UserErrorException {
        DataBean bean = this.getDataset(dataset);
        try (ChecksumInputStream stream = this.app.getDataManager().getContentStream(bean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);){
            IOUtils.copy((InputStream)stream, (OutputStream)System.out);
        }
    }

    private void viewDataset(String dataset, boolean yaml) throws UserErrorException {
        DataBean bean = this.getDataset(dataset);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_NAME, bean.getName());
        map.put(KEY_DATE, new DateTime((Object)bean.getDate()).toString());
        map.put(KEY_SIZE, bean.getSize());
        map.put(KEY_NOTES, bean.getNotes());
        OperationRecord oper = bean.getOperationRecord();
        map.put("tool", oper.getNameID().getID());
        ArrayList<String> inputs = new ArrayList<String>();
        for (OperationRecord.InputRecord input : oper.getInputRecords()) {
            String inputName = "";
            inputName = input.getValue() != null ? input.getValue().getName() : input.getDataId();
            inputs.add(inputName);
        }
        map.put(KEY_INPUTS, inputs);
        ArrayList<HashMap<String, String>> params = this.getParameters(oper);
        map.put(KEY_PARAMETERS, params);
        HashMap outputTools = new HashMap();
        for (DataBean dataBean : bean.getLinkSources(DataBean.Link.derivationalTypes())) {
            String outputTool = dataBean.getOperationRecord().getNameID().getID();
            if (!outputTools.containsKey(outputTool)) {
                outputTools.put(outputTool, new ArrayList());
            }
            ((ArrayList)outputTools.get(outputTool)).add(dataBean.getName());
        }
        map.put("input of", outputTools);
        if (yaml) {
            this.dumpYaml(map);
        } else {
            System.out.println("Dataset            " + map.get(KEY_NAME));
            System.out.println("Date               " + map.get(KEY_DATE));
            System.out.println("Size               " + map.get(KEY_SIZE) + " bytes");
            System.out.println("Notes              " + map.get(KEY_NOTES));
            System.out.println("Produced by tool   " + map.get("tool"));
            System.out.print("Using inputs       ");
            System.out.println(Strings.delimit(inputs, " "));
            System.out.print("Parameters         ");
            for (HashMap hashMap : params) {
                System.out.print((String)hashMap.get("parameter") + "=" + (String)hashMap.get(KEY_VALUE) + " ");
            }
            System.out.println();
            System.out.println();
            System.out.print(StringUtils.rightPad((String)"INPUT OF", (int)50));
            System.out.print("OUTPUT DATASETS");
            System.out.println();
            for (String string : outputTools.keySet()) {
                System.out.print(StringUtils.rightPad((String)string, (int)50));
                ArrayList outputDatasets = (ArrayList)outputTools.get(string);
                System.out.println(Strings.delimit(outputDatasets, " "));
            }
        }
    }

    private void listDatasets(boolean yaml) {
        ArrayList<String> list = new ArrayList<String>();
        for (DataBean bean : this.app.getDataManager().databeans()) {
            list.add(bean.getName());
        }
        this.print(list, yaml);
    }

    private void print(ArrayList<String> list, boolean yaml) {
        if (yaml) {
            this.dumpYaml(list);
        } else {
            for (String item : list) {
                System.out.println(item);
            }
        }
    }

    private void dumpYaml(Object yaml) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yamlLib = new Yaml(options);
        System.out.print(yamlLib.dump(yaml));
    }

    private String parameterToString(HashMap<String, Object> map) {
        String str = "";
        str = str + StringUtils.rightPad((String)((String)map.get("parameter")), (int)30);
        String type = "";
        switch ((String)map.get(KEY_TYPE)) {
            case "INTEGER": {
                type = "integer" + this.minMaxDefaultToString(map);
                break;
            }
            case "DECIMAL": {
                type = "decimal" + this.minMaxDefaultToString(map);
                break;
            }
            case "PERCENT": {
                type = "percent" + this.minMaxDefaultToString(map);
                break;
            }
            case "STRING": {
                type = "string" + this.minMaxDefaultToString(map);
                break;
            }
            case "METACOLUMN_SEL ": {
                type = "phenodata column selection" + this.minMaxDefaultToString(map);
                break;
            }
            case "ENUM": {
                type = map.containsKey(KEY_MAX) && (Integer)map.get(KEY_MAX) > 1 ? "multiple selection" : "single selection";
                if (!map.containsKey(KEY_DEFAULT)) break;
                type = type + ", default " + map.get(KEY_DEFAULT);
            }
        }
        str = str + StringUtils.rightPad((String)type, (int)40);
        str = str + "\n";
        str = str + "    " + (String)map.get(KEY_NAME) + "\n";
        if (map.containsKey(KEY_OPTIONS)) {
            str = str + "\n";
            str = str + "    " + StringUtils.rightPad((String)"OPTION", (int)60) + "NAME\n";
            for (HashMap option : (ArrayList)map.get(KEY_OPTIONS)) {
                str = str + "    ";
                str = str + StringUtils.rightPad((String)((String)option.get(KEY_OPTION)), (int)60);
                str = str + (String)option.get(KEY_NAME) + "\n";
            }
        }
        return str;
    }

    private String minMaxDefaultToString(HashMap<String, Object> map) {
        String str = "";
        if (map.containsKey(KEY_MIN) || map.containsKey(KEY_MAX)) {
            str = str + " " + map.get(KEY_MIN) + "-" + map.get(KEY_MAX);
        }
        if (map.containsKey(KEY_DEFAULT)) {
            str = str + ", default " + map.get(KEY_DEFAULT);
        }
        return str;
    }

    private HashMap<String, Object> parameterToYaml(Parameter parameter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parameter instanceof IntegerParameter) {
            map.put(KEY_TYPE, KEY_INTEGER);
            IntegerParameter number = (IntegerParameter)parameter;
            map.put(KEY_DEFAULT, number.getIntegerValue());
            if (number.getMinValue() != Integer.MIN_VALUE) {
                map.put(KEY_MIN, number.getMinValue());
            }
            if (number.getMaxValue() != Integer.MAX_VALUE) {
                map.put(KEY_MAX, number.getMaxValue());
            }
            return map;
        }
        if (parameter instanceof DecimalParameter) {
            map.put(KEY_TYPE, KEY_DECIMAL);
            DecimalParameter number = (DecimalParameter)parameter;
            map.put(KEY_DEFAULT, number.getDecimalValue());
            if (number.getMinValue().floatValue() != Float.MIN_VALUE) {
                map.put(KEY_MIN, number.getMinValue());
            }
            if (number.getMaxValue().floatValue() != Float.MAX_VALUE) {
                map.put(KEY_MAX, number.getMaxValue());
            }
            return map;
        }
        if (parameter instanceof PercentageParameter) {
            map.put(KEY_TYPE, KEY_PERCENT);
            PercentageParameter number = (PercentageParameter)parameter;
            map.put(KEY_DEFAULT, number.getIntegerValue());
            if (number.getMinValue() != Integer.MIN_VALUE) {
                map.put(KEY_MIN, number.getMinValue());
            }
            if (number.getMaxValue() != Integer.MAX_VALUE) {
                map.put(KEY_MAX, number.getMaxValue());
            }
            return map;
        }
        if (parameter instanceof StringParameter) {
            map.put(KEY_TYPE, KEY_STRING);
            map.put(KEY_DEFAULT, parameter.getValueAsString());
            return map;
        }
        if (parameter instanceof MetaColnameParameter) {
            map.put(KEY_TYPE, KEY_METACOLUMN_SEL);
            map.put(KEY_DEFAULT, parameter.getValueAsString());
            return map;
        }
        if (parameter instanceof EnumParameter) {
            EnumParameter enumParam = (EnumParameter)parameter;
            map.put(KEY_TYPE, KEY_ENUM);
            map.put(KEY_DEFAULT, enumParam.getValueAsString());
            map.put(KEY_MIN, enumParam.getMinCount());
            map.put(KEY_MAX, enumParam.getMaxCount());
            map.put(KEY_OPTIONS, this.enumOptionsToYaml(enumParam));
            return map;
        }
        throw new IllegalArgumentException("The given Parameter object, " + parameter.getID() + ", was not of recognized type!");
    }

    private ArrayList<HashMap<String, String>> enumOptionsToYaml(EnumParameter enumParam) {
        ArrayList<HashMap<String, String>> options = new ArrayList<HashMap<String, String>>();
        if (enumParam.getOptions() != null) {
            for (EnumParameter.SelectionOption opt : (EnumParameter.SelectionOption[])enumParam.getOptions()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(KEY_OPTION, opt.getValue());
                map.put(KEY_NAME, opt.toString());
                options.add(map);
            }
        }
        return options;
    }

    private DataBean getDataset(String name) throws UserErrorException {
        DataBean bean = this.app.getDataManager().getDataBean(name);
        if (bean == null) {
            throw new UserErrorException("dataset not found: " + name);
        }
        return bean;
    }

    private String getSessionId(String sessionName) throws JMSException, Exception {
        List<DbSession> sessions = this.app.getSessionManager().listRemoteSessions();
        for (DbSession session : sessions) {
            if (!sessionName.equals(session.getName())) continue;
            return session.getDataId();
        }
        throw new UserErrorException("session not found: " + sessionName);
    }

    private OperationDefinition getTool(String name) throws UserErrorException {
        OperationDefinition tool = this.app.getOperationDefinition(name);
        if (tool == null) {
            throw new UserErrorException("tool not found: " + name);
        }
        return tool;
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }

    private static class YamlModule
    extends HashMap<String, YamlCategory> {
        private YamlModule() {
        }
    }

    private static class YamlCategory
    extends ArrayList<YamlTool> {
        private YamlCategory() {
        }
    }

    private static class YamlTool
    extends HashMap<String, String> {
        private YamlTool() {
        }
    }

    public class ShutdownRunnable
    implements Runnable {
        private int exitValue;

        public ShutdownRunnable(int exitValue) {
            this.exitValue = exitValue;
        }

        @Override
        public void run() {
            if (CliClient.this.app != null) {
                CliClient.this.app.quit();
            }
            System.exit(this.exitValue);
        }
    }
}

