/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessionworker.SessionWorkerResource;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class SessionWorker {
    private Logger logger = LogManager.getLogger();
    private String serviceId;
    private ServiceLocatorClient serviceLocator;
    private Config config;
    private HttpServer httpServer;
    private SessionWorkerResource sessionWorkerResource;
    private AuthenticationClient authService;
    private HttpServer adminServer;

    public SessionWorker(Config config) {
        this.config = config;
    }

    public void startServer() throws ServletException, DeploymentException, RestException, IOException {
        String username = "session-worker";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        TokenRequestFilter tokenRequestFilter = new TokenRequestFilter(this.authService);
        this.sessionWorkerResource = new SessionWorkerResource(this.serviceLocator);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)this.sessionWorkerResource).register((Object)tokenRequestFilter);
        JerseyStatisticsSource jerseyStatisticsSource = RestUtils.createJerseyStatisticsSource(rc);
        URI baseUri = URI.create(this.config.getBindUrl("session-worker"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc, (boolean)false);
        jerseyStatisticsSource.collectConnectionStatistics(this.httpServer);
        this.httpServer.start();
        this.adminServer = RestUtils.startAdminServer("session-worker", this.config, this.authService, jerseyStatisticsSource);
    }

    public static void main(String[] args) throws IOException, ServletException, DeploymentException, RestException {
        SessionWorker service = new SessionWorker(new Config());
        RestUtils.shutdownGracefullyOnInterrupt(service.getHttpServer(), service.config.getInt("file-broker-shutdown-timeout"), "session-worker");
        service.startServer();
        RestUtils.waitForShutdown("session-worker", service.getHttpServer());
    }

    public void close() {
        RestUtils.shutdown("session-worker-admin", this.adminServer);
        RestUtils.shutdown("session-worker", this.httpServer);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }
}

