/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.sessiondb.model.Rule;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.resource.RuleTable;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="authorizations")
public class RuleResource {
    private UUID sessionId;
    private RuleTable authorizationTable;
    private HibernateUtil hibernate;
    private Config config;

    public RuleResource(SessionResource sessionResource, UUID id, RuleTable authorizationTable, Config config) {
        this.sessionId = id;
        this.authorizationTable = authorizationTable;
        this.hibernate = sessionResource.getHibernate();
        this.config = config;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"session-db"})
    @Transaction
    public Response get(@PathParam(value="id") UUID authorizationId, @Context SecurityContext sc) throws IOException {
        Rule result = this.authorizationTable.getRule(authorizationId, this.hibernate.session());
        if (result == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transaction
    public Response getBySession(@Context SecurityContext sc) {
        this.authorizationTable.checkAuthorization(sc.getUserPrincipal().getName(), this.sessionId, false);
        List<Rule> authorizations = this.authorizationTable.getRules(this.sessionId);
        return Response.ok(authorizations).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Transaction
    public Response post(Rule newAuthorization, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        String publicSharingUsername;
        if (newAuthorization.getRuleId() != null) {
            throw new BadRequestException("authorization already has an id, post not allowed");
        }
        if ("everyone".equals(newAuthorization.getUsername()) && !(publicSharingUsername = this.config.getString("session-db-restrict-sharing-to-everyone")).isEmpty() && !publicSharingUsername.equals(sc.getUserPrincipal().getName())) {
            throw new ForbiddenException("sharing to everyone is not allowed for this user");
        }
        Session session = this.authorizationTable.getSessionForWriting(sc, this.sessionId);
        newAuthorization.setRuleId(RestUtils.createUUID());
        newAuthorization.setSession(session);
        newAuthorization.setSharedBy(sc.getUserPrincipal().getName());
        this.authorizationTable.save(newAuthorization, this.hibernate.session());
        URI uri = uriInfo.getAbsolutePathBuilder().path(newAuthorization.getRuleId().toString()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    @DELETE
    @Path(value="{id}")
    @Transaction
    public Response delete(@PathParam(value="id") UUID authorizationId, @Context SecurityContext sc) {
        Rule authorizationToDelete = this.authorizationTable.getRule(authorizationId, this.hibernate.session());
        if (!authorizationToDelete.getUsername().equals(sc.getUserPrincipal().getName())) {
            this.authorizationTable.checkAuthorization(sc.getUserPrincipal().getName(), this.sessionId, true);
        }
        this.authorizationTable.delete(this.sessionId, authorizationToDelete, this.hibernate.session());
        return Response.noContent().build();
    }
}

