/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateRequestFilter;
import fi.csc.chipster.rest.hibernate.HibernateResponseFilter;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.SessionDbTopicConfig;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.DatasetToken;
import fi.csc.chipster.sessiondb.model.File;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Rule;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.resource.DatasetTokenResource;
import fi.csc.chipster.sessiondb.resource.DatasetTokenTable;
import fi.csc.chipster.sessiondb.resource.GlobalJobResource;
import fi.csc.chipster.sessiondb.resource.RuleTable;
import fi.csc.chipster.sessiondb.resource.SessionDbAdminResource;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class SessionDb {
    private Logger logger = LogManager.getLogger();
    public static final String EVENTS_PATH = "events";
    private static HibernateUtil hibernate;
    private String serviceId;
    private ServiceLocatorClient serviceLocator;
    private AuthenticationClient authService;
    private Config config;
    private HttpServer httpServer;
    private PubSubServer pubSubServer;
    private SessionResource sessionResource;
    private RuleTable authorizationTable;
    private SessionDbAdminResource adminResource;
    private GlobalJobResource globalJobResource;
    private DatasetTokenResource datasetTokenResource;
    private TokenRequestFilter tokenRequestFilter;
    private HttpServer adminServer;

    public SessionDb(Config config) {
        this.config = config;
    }

    public void startServer() throws Exception {
        String username = "session-db";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        List<Class<?>> hibernateClasses = Arrays.asList(DatasetToken.class, Rule.class, Session.class, Dataset.class, MetadataEntry.class, Job.class, Parameter.class, Input.class, File.class);
        hibernate = new HibernateUtil(this.config, "session");
        hibernate.buildSessionFactory(hibernateClasses);
        this.tokenRequestFilter = new TokenRequestFilter(this.authService);
        this.tokenRequestFilter.authenticationRequired(false, true);
        DatasetTokenTable datasetTokenTable = new DatasetTokenTable(hibernate);
        this.authorizationTable = new RuleTable(hibernate, datasetTokenTable, this.tokenRequestFilter);
        this.datasetTokenResource = new DatasetTokenResource(datasetTokenTable, this.authorizationTable);
        this.sessionResource = new SessionResource(hibernate, this.authorizationTable, this.config);
        this.globalJobResource = new GlobalJobResource(hibernate);
        String pubSubUri = this.config.getBindUrl("session-db-events");
        String path = "events/{topic-name}";
        SessionDbTopicConfig topicConfig = new SessionDbTopicConfig(this.authService, hibernate, this.sessionResource);
        this.pubSubServer = new PubSubServer(pubSubUri, path, null, topicConfig, "session-db-events");
        this.pubSubServer.setIdleTimeout(this.config.getLong("websocket-idle-timeout"));
        this.pubSubServer.start();
        this.sessionResource.setPubSubServer(this.pubSubServer);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)this.datasetTokenResource).register((Object)this.authorizationTable).register((Object)this.sessionResource).register((Object)this.globalJobResource).register((Object)new HibernateRequestFilter(hibernate)).register((Object)new HibernateResponseFilter(hibernate)).register((Object)this.tokenRequestFilter);
        JerseyStatisticsSource jerseyStatisticsSource = RestUtils.createJerseyStatisticsSource(rc);
        this.adminResource = new SessionDbAdminResource(hibernate, jerseyStatisticsSource, this.pubSubServer);
        URI baseUri = URI.create(this.config.getBindUrl("session-db"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
        jerseyStatisticsSource.collectConnectionStatistics(this.httpServer);
        this.httpServer.start();
        this.adminServer = RestUtils.startAdminServer((Object)this.adminResource, hibernate, "session-db", this.config, this.authService);
    }

    public PubSubServer getPubSubServer() {
        return this.pubSubServer;
    }

    public static void main(String[] args) throws Exception {
        SessionDb service = new SessionDb(new Config());
        service.startServer();
        RestUtils.shutdownGracefullyOnInterrupt(service.getHttpServer(), "session-db");
        RestUtils.waitForShutdown("session-db", service.getHttpServer());
        hibernate.getSessionFactory().close();
    }

    public static HibernateUtil getHibernate() {
        return hibernate;
    }

    public void close() {
        RestUtils.shutdown("session-db-admin", this.adminServer);
        this.getPubSubServer().stop();
        RestUtils.shutdown("session-db", this.httpServer);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }
}

