/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.scheduler;

import fi.csc.chipster.scheduler.IdPair;
import fi.csc.chipster.scheduler.JobSchedulingState;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SchedulerJobs {
    HashMap<IdPair, JobSchedulingState> jobs = new HashMap();

    public Map<IdPair, JobSchedulingState> getRunningJobs() {
        Map<IdPair, JobSchedulingState> runningJobs = this.jobs.entrySet().stream().filter(entry -> ((JobSchedulingState)entry.getValue()).isRunning()).collect(Collectors.toMap(e -> (IdPair)e.getKey(), e -> (JobSchedulingState)e.getValue()));
        return runningJobs;
    }

    public Map<IdPair, JobSchedulingState> getScheduledJobs() {
        Map<IdPair, JobSchedulingState> scheduledJobs = this.jobs.entrySet().stream().filter(entry -> ((JobSchedulingState)entry.getValue()).isScheduled()).collect(Collectors.toMap(e -> (IdPair)e.getKey(), e -> (JobSchedulingState)e.getValue()));
        return scheduledJobs;
    }

    public Map<IdPair, JobSchedulingState> getNewJobs() {
        Map<IdPair, JobSchedulingState> newJobs = this.jobs.entrySet().stream().filter(entry -> ((JobSchedulingState)entry.getValue()).isNew()).collect(Collectors.toMap(e -> (IdPair)e.getKey(), e -> (JobSchedulingState)e.getValue()));
        return newJobs;
    }

    public void remove(IdPair jobId) {
        this.jobs.remove(jobId);
    }

    public void addNewJob(IdPair idPair) {
        this.jobs.put(idPair, new JobSchedulingState());
    }

    public void addRunningJob(IdPair idPair) {
        JobSchedulingState job = new JobSchedulingState();
        job.setScheduleTimestamp();
        job.setRunningTimestamp();
        this.jobs.put(idPair, new JobSchedulingState());
    }

    public JobSchedulingState get(IdPair jobIdPair) {
        return this.jobs.get(jobIdPair);
    }
}

