/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.HandshakeException;

public class RetryHandler
extends ClientManager.ReconnectHandler {
    private static final Logger logger = LogManager.getLogger();
    private int counter = 0;
    private int retries = 30;
    private String name;
    private volatile boolean close = false;

    public RetryHandler(String name) {
        this.name = name;
    }

    public boolean onDisconnect(CloseReason closeReason) {
        if (this.close) {
            return false;
        }
        if (CloseReason.CloseCodes.VIOLATED_POLICY == closeReason.getCloseCode()) {
            logger.error("reconnection cancelled");
            throw new RuntimeException(closeReason.getReasonPhrase());
        }
        ++this.counter;
        if (this.counter <= this.retries) {
            logger.info("reconnecting... (" + this.counter + "/" + this.retries + ")");
            return true;
        }
        return false;
    }

    public boolean onConnectFailure(Exception exception) {
        logger.info("websocket client " + this.name + " connection failure", (Throwable)exception);
        if (exception instanceof DeploymentException && exception.getCause() instanceof HandshakeException) {
            logger.error("unrecoverable connection failure, reconnection cancelled");
            return false;
        }
        ++this.counter;
        if (this.counter <= this.retries) {
            logger.info("reconnecting... (" + this.counter + "/" + this.retries + ")");
            return true;
        }
        return false;
    }

    public long getDelay() {
        if (this.counter < 1) {
            return 0L;
        }
        if (this.counter < 15) {
            return 1L;
        }
        if (this.counter < 30) {
            return 10L;
        }
        return 60L;
    }

    public void close() {
        this.close = true;
    }

    public void reset() {
        this.counter = 0;
    }
}

