/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import fi.csc.microarray.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavascriptService {
    private Logger logger = LogManager.getLogger();
    private String serviceRootPath;
    private Process process;
    private File serviceRoot;

    public JavascriptService(String serviceRootPath) {
        this.serviceRootPath = serviceRootPath;
    }

    public void startServer() throws IOException, ConfigurationLoader.IllegalConfigurationException, InterruptedException {
        this.serviceRoot = new File(this.serviceRootPath);
        if (!this.serviceRoot.exists()) {
            throw new ConfigurationLoader.IllegalConfigurationException("typescript project " + this.serviceRootPath + " not found");
        }
        System.out.println("Install dependencies");
        this.runAndWait("npm", "install");
        System.out.println("Compile");
        this.runAndWaitCareless("npm", "run", "build");
        System.out.println("Run");
        ProcessBuilder builder = this.getProcessBuilder("npm", "start");
        this.process = builder.start();
        Thread.sleep(5000L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    JavascriptService.this.close();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runAndWait(String ... command) throws IOException, InterruptedException {
        int exitCode = this.runAndWaitCareless(command);
        if (exitCode != 0) {
            throw new IllegalStateException("error in command " + StringUtils.join((Object[])command, (String)" ") + ", exit code " + exitCode);
        }
    }

    private int runAndWaitCareless(String ... command) throws InterruptedException, IOException {
        ProcessBuilder builder = this.getProcessBuilder(command);
        this.process = builder.start();
        return this.process.waitFor();
    }

    private ProcessBuilder getProcessBuilder(String ... command) {
        List<String> commandList = Arrays.asList(command);
        commandList.set(0, this.getPath(commandList.get(0)));
        ProcessBuilder builder = new ProcessBuilder(commandList);
        builder.environment().put("PATH", StringUtils.join(this.getPaths(), (String)":"));
        builder.inheritIO();
        builder.directory(this.serviceRoot);
        return builder;
    }

    private List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(System.getenv("PATH").split(":")));
        paths.add("/usr/local/bin");
        return paths;
    }

    private String getPath(String command) {
        for (String path : this.getPaths()) {
            File binary = new File(new File(path), command);
            if (!binary.exists()) continue;
            System.out.println("using binary " + binary.getAbsolutePath());
            return binary.getAbsolutePath();
        }
        throw new IllegalArgumentException("command " + command + " not found from PATH");
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.IllegalConfigurationException, InterruptedException {
        if (args.length != 1) {
            System.out.println("1 argument required: path to npm project to run");
            System.exit(1);
        }
        String serviceName = args[0];
        JavascriptService server = new JavascriptService(serviceName);
        server.startServer();
    }

    public void close() throws InterruptedException {
        this.logger.info("JavaScript service shutting down");
        this.process.destroy();
        this.process.waitFor();
        this.logger.info("JavaScript service stopped");
    }
}

