/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.ConnectionManager;
import fi.csc.chipster.proxy.WebSocketProxyClient;
import fi.csc.chipster.proxy.WebSocketProxyServlet;
import fi.csc.chipster.proxy.model.Connection;
import fi.csc.chipster.proxy.model.Route;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.glassfish.tyrus.client.ClientManager;

public class WebSocketProxySocket
extends WebSocketAdapter {
    public static final Logger logger = LogManager.getLogger();
    private Session socketSession;
    private WebSocketProxyClient proxyClient;
    private String prefix;
    private String proxyTo;
    private ConnectionManager connectionManager;
    private Connection connection;

    public WebSocketProxySocket(String prefix, String proxyTo, ConnectionManager connectionManager) {
        this.prefix = prefix;
        this.proxyTo = proxyTo;
        this.connectionManager = connectionManager;
    }

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        this.socketSession = sess;
        String targetUri = this.getTargetUri(this.socketSession);
        logger.debug("proxy " + this.socketSession.getUpgradeRequest().getRequestURI() + " \t -> " + targetUri);
        this.connectToTarget(targetUri);
        this.connection = new Connection();
        this.connection.setSourceAddress(this.socketSession.getRemoteAddress().getHostString().toString());
        this.connection.setRequestURI(this.socketSession.getUpgradeRequest().getRequestURI().toString());
        this.connection.setRoute(new Route(this.prefix.substring(1), this.proxyTo));
        this.connectionManager.addConnection(this.connection);
    }

    public void onWebSocketText(String message) {
        super.onWebSocketText(message);
        this.proxyClient.sendText(message);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        this.proxyClient.closeClientSession(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)statusCode), reason));
        this.connectionManager.removeConnection(this.connection);
    }

    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
        this.proxyClient.closeClientSession(WebSocketProxyServlet.toCloseReason(cause));
        this.connectionManager.removeConnection(this.connection);
    }

    private void connectToTarget(String targetUri) {
        CountDownLatch connectLatch = new CountDownLatch(1);
        this.proxyClient = new WebSocketProxyClient(this, connectLatch, targetUri);
        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
        ClientManager client = ClientManager.createClient();
        try {
            client.connectToServer((Endpoint)this.proxyClient, cec, new URI(targetUri));
            connectLatch.await();
        }
        catch (DeploymentException e) {
            this.closeSocketSession(WebSocketProxyServlet.toCloseReason(e));
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            logger.error("failed to connect to " + targetUri, (Throwable)e);
            this.closeSocketSession(WebSocketProxyServlet.toCloseReason(e));
        }
    }

    private String getTargetUri(Session sourceSession) {
        URI requestUri = sourceSession.getUpgradeRequest().getRequestURI();
        String requestPath = requestUri.getPath();
        if (!requestPath.startsWith(this.prefix + "/")) {
            throw new IllegalArgumentException("path " + requestPath + " doesn't start with prefix " + this.prefix);
        }
        requestPath = requestPath.replaceFirst(this.prefix + "/", "");
        UriBuilder targetUriBuilder = UriBuilder.fromUri((String)this.proxyTo);
        targetUriBuilder.path(requestPath);
        targetUriBuilder.replaceQuery(requestUri.getQuery());
        return targetUriBuilder.build(new Object[0]).toString();
    }

    public void closeSocketSession(CloseReason closeReason) {
        this.socketSession.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void sendText(String message) {
        try {
            this.socketSession.getRemote().sendString(message);
        }
        catch (IOException e) {
            logger.error("failed to send a message", (Throwable)e);
            this.proxyClient.closeClientSession(WebSocketProxyServlet.toCloseReason(e));
            this.closeSocketSession(WebSocketProxyServlet.toCloseReason(e));
        }
    }
}

