/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.WebSocketProxyServlet;
import fi.csc.chipster.proxy.WebSocketProxySocket;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketProxyClient
extends Endpoint {
    private static final Logger logger = LogManager.getLogger();
    private WebSocketProxySocket proxySocket;
    private Session clientSession;
    private String targetUri;
    private CountDownLatch connectLatch;

    public WebSocketProxyClient(WebSocketProxySocket jettyWebSocketSourceEndpoint, CountDownLatch openLatch, String targetUri) {
        this.proxySocket = jettyWebSocketSourceEndpoint;
        this.connectLatch = openLatch;
        this.targetUri = targetUri;
    }

    public void onOpen(Session targetSession, EndpointConfig config) {
        this.clientSession = targetSession;
        targetSession.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                WebSocketProxyClient.this.proxySocket.sendText(message);
            }
        });
        this.connectLatch.countDown();
    }

    public void onClose(Session session, CloseReason reason) {
        this.connectLatch.countDown();
        this.proxySocket.closeSocketSession(reason);
    }

    public void onError(Session session, Throwable thr) {
        this.connectLatch.countDown();
        this.proxySocket.closeSocketSession(WebSocketProxyServlet.toCloseReason(thr));
    }

    public void sendText(String message) {
        try {
            this.clientSession.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            logger.error("failed to send a message to " + this.targetUri, (Throwable)e);
            this.proxySocket.closeSocketSession(WebSocketProxyServlet.toCloseReason(e));
            this.closeClientSession(WebSocketProxyServlet.toCloseReason(e));
        }
    }

    public void closeClientSession(CloseReason closeReason) {
        try {
            if (this.clientSession != null) {
                this.clientSession.close(closeReason);
            }
        }
        catch (IOException e) {
            logger.error("failed to close the target websocket to " + this.targetUri, (Throwable)e);
        }
    }
}

