/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.ConnectionManager;
import fi.csc.chipster.proxy.model.Connection;
import fi.csc.chipster.proxy.model.Route;
import java.io.IOException;
import javax.inject.Singleton;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.proxy.ProxyServlet;

@Singleton
public class HttpProxyServlet
extends ProxyServlet.Transparent {
    private final Logger logger = LogManager.getLogger();
    private ConnectionManager connectionManager;

    public HttpProxyServlet(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
        final Connection connection = new Connection();
        connection.setSourceAddress(request.getRemoteAddr());
        connection.setRequestURI(request.getRequestURL().toString());
        connection.setRoute(new Route(this.getProxyPath(), this.getProxyTo()));
        connection.setMethod(request.getMethod());
        this.connectionManager.addConnection(connection);
        request.getAsyncContext().addListener(new AsyncListener(){

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                HttpProxyServlet.this.connectionManager.removeConnection(connection);
            }

            public void onError(AsyncEvent event) throws IOException {
                HttpProxyServlet.this.connectionManager.removeConnection(connection);
            }

            public void onComplete(AsyncEvent event) throws IOException {
                HttpProxyServlet.this.connectionManager.removeConnection(connection);
            }
        });
    }

    protected String rewriteTarget(HttpServletRequest request) {
        String rewritten = super.rewriteTarget(request);
        StringBuffer original = request.getRequestURL();
        this.logger.debug("proxy " + original + " \t -> " + rewritten);
        return rewritten;
    }

    public String getProxyPath() {
        return this.getInitParameter("prefix").substring(1);
    }

    public String getProxyTo() {
        return this.getInitParameter("proxyTo");
    }
}

