/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.proxy.ChipsterProxyAdminResource;
import fi.csc.chipster.proxy.ProxyServer;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;

public class ChipsterProxyServer {
    private final Logger logger = LogManager.getLogger();
    private ProxyServer proxy;
    private ServiceLocatorClient serviceLocator;
    private AuthenticationClient authService;
    private String serviceId;
    private HttpServer adminServer;
    private Config config;

    public static void main(String[] args) throws IOException {
        ChipsterProxyServer server = new ChipsterProxyServer(new Config());
        server.startServer();
        RestUtils.waitForShutdown("proxy", null);
        server.close();
    }

    public ChipsterProxyServer(Config config) {
        this.config = config;
        try {
            this.proxy = new ProxyServer(URI.create(config.getBindUrl("proxy")));
            for (Map.Entry<String, String> entry : config.getExternalServiceUrls().entrySet()) {
                String service = entry.getKey();
                String externalAddress = entry.getValue();
                if ("proxy".equals(service) || "web-server".equals(service)) continue;
                this.proxy.addRoute(service.replace("-", ""), externalAddress);
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("proxy configuration error", (Throwable)e);
        }
    }

    private void startAdminAPI() throws IOException {
        String username = "proxy";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        this.adminServer = RestUtils.startAdminServer((Object)new ChipsterProxyAdminResource(this.proxy), null, "proxy", this.config, this.authService);
    }

    public void startServer() throws IOException {
        this.proxy.startServer();
        this.startAdminAPI();
    }

    public void close() {
        RestUtils.shutdown("proxy-admin", this.adminServer);
        this.proxy.close();
    }
}

