/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth.model;

import fi.csc.chipster.rest.RestUtils;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@XmlRootElement
public class Token {
    @Id
    @Column(columnDefinition="uuid", updatable=false)
    private UUID tokenKey;
    private String username;
    private LocalDateTime valid;
    private LocalDateTime creationTime;
    private String rolesJson;

    public Token() {
    }

    public Token(String username, UUID token, LocalDateTime valid, LocalDateTime creationTime, String rolesJson) {
        this.username = username;
        this.tokenKey = token;
        this.valid = valid;
        this.creationTime = creationTime;
        this.setRolesJson(rolesJson);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UUID getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(UUID token) {
        this.tokenKey = token;
    }

    public LocalDateTime getValid() {
        return this.valid;
    }

    public void setValid(LocalDateTime valid) {
        this.valid = valid;
    }

    public String getRolesJson() {
        return this.rolesJson;
    }

    public void setRolesJson(String rolesJson) {
        this.rolesJson = rolesJson;
    }

    public HashSet<String> getRoles() {
        return RestUtils.parseJson(HashSet.class, this.rolesJson);
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }
}

