/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import java.util.LinkedList;
import java.util.List;

public class ModuleManager {
    private LinkedList<Module> modules = new LinkedList();
    private Module primaryModule = null;

    public ModuleManager() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this(null);
    }

    public ModuleManager(String primaryModuleClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.modules.add(new BasicModule());
        if (primaryModuleClass != null) {
            Module primaryModule;
            this.primaryModule = primaryModule = (Module)Class.forName(primaryModuleClass).newInstance();
            this.modules.add(primaryModule);
        } else {
            this.primaryModule = this.modules.getLast();
        }
    }

    public void plugAll(DataManager manager, Session session) {
        for (Module module : this.modules) {
            module.plugFeatures(manager);
            module.plugModifiers(manager);
            module.plugContentTypes(manager);
            if (session == null) continue;
            session.getVisualisations().addVisualisationMethods(module.getVisualisationMethods());
        }
        manager.setModules(this.modules);
    }

    public void addModule(Module module) {
        this.modules.add(module);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public Module getPrimaryModule() {
        return this.primaryModule;
    }
}

