/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SuccessMessageListener
extends TempTopicMessagingListenerBase {
    private SuccessMessage message;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cancelled = false;

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        if (msg instanceof SuccessMessage) {
            this.message = (SuccessMessage)msg;
            this.latch.countDown();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.latch.countDown();
    }

    public SuccessMessage waitForReply(long timeout, TimeUnit unit) throws AuthCancelledException {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUp();
        }
        if (this.cancelled) {
            throw new AuthCancelledException();
        }
        return this.message;
    }
}

