/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.filebroker.QuotaExceededException;
import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.BooleanMessageListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.ReplyMessageListener;
import fi.csc.microarray.messaging.SuccessMessageListener;
import fi.csc.microarray.messaging.UrlListMessageListener;
import fi.csc.microarray.messaging.UrlMessageListener;
import fi.csc.microarray.messaging.admin.StorageAdminAPI;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.KeyAndTrustManager;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class JMSFileBrokerClient
implements FileBrokerClient {
    private static final int SPACE_REQUEST_TIMEOUT = 300;
    private static final int QUICK_POLL_OPERATION_TIMEOUT = 30;
    private static final int MOVE_FROM_CACHE_TO_STORAGE_TIMEOUT = 24;
    private static final Logger logger = Logger.getLogger(JMSFileBrokerClient.class);
    private MessagingTopic filebrokerTopic;
    private boolean useChunked;
    private boolean useCompression;
    private File localFilebrokerCache;
    private File localFilebrokerStorage;
    private boolean useChecksums;
    private String overridingFilebrokerIp;

    public JMSFileBrokerClient(MessagingTopic urlTopic, String localFilebrokerPath, String overridingFilebrokerIp) throws JMSException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException, KeyManagementException {
        this.filebrokerTopic = urlTopic;
        this.overridingFilebrokerIp = overridingFilebrokerIp;
        if (localFilebrokerPath != null) {
            this.localFilebrokerCache = new File(localFilebrokerPath, "cache");
            this.localFilebrokerStorage = new File(localFilebrokerPath, "storage");
        }
        this.useChunked = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-chunked-http");
        this.useCompression = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-compression");
        this.useChecksums = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-checksums");
        KeyAndTrustManager.initialiseTrustStore();
    }

    public JMSFileBrokerClient(MessagingTopic urlTopic) throws Exception {
        this(urlTopic, null, null);
    }

    @Override
    public void addFile(UUID jobId, UUID sessionId, String dataId, FileBrokerClient.FileBrokerArea area, File file, IOUtils.CopyProgressListener progressListener, String datsetName) throws FileBrokerException, IOException {
        if (area != FileBrokerClient.FileBrokerArea.CACHE) {
            throw new UnsupportedOperationException();
        }
        if (file.length() > 0L && !this.requestDiskSpace(file.length())) {
            throw new NotEnoughDiskSpaceException();
        }
        URL url = this.getNewURL(dataId, this.useCompression, FileBrokerClient.FileBrokerArea.CACHE, file.length());
        if (url == null) {
            throw new FileBrokerException("filebroker is not responding");
        }
        if (this.localFilebrokerCache != null && !this.useCompression) {
            String filename = dataId;
            File dest = new File(this.localFilebrokerCache, filename);
            boolean success = file.renameTo(dest);
            if (!success) {
                IOUtils.copy(file, dest);
            }
        } else {
            FileInputStream stream = new FileInputStream(file);
            try {
                String md5 = UrlTransferUtil.uploadStream(url, stream, this.useChunked, this.useCompression, this.useChecksums, progressListener);
                logger.debug((Object)("successfully uploaded: " + url + "\tlength: " + file.length() + "\tmd5: " + md5));
            }
            catch (ChecksumException e) {
                throw new IOException(e);
            }
            finally {
                IOUtils.closeIfPossible(stream);
            }
        }
    }

    @Override
    public String addFile(String dataId, FileBrokerClient.FileBrokerArea area, InputStream file, long contentLength, IOUtils.CopyProgressListener progressListener) throws FileBrokerException, IOException {
        String md5;
        URL url;
        if (area == FileBrokerClient.FileBrokerArea.CACHE) {
            if (contentLength > 0L && !this.requestDiskSpace(contentLength)) {
                throw new NotEnoughDiskSpaceException();
            }
            url = this.getNewURL(dataId, this.useCompression, FileBrokerClient.FileBrokerArea.CACHE, contentLength);
            if (url == null) {
                throw new FileBrokerException("New URL is null.");
            }
        } else {
            url = this.getNewURL(dataId, this.useCompression, FileBrokerClient.FileBrokerArea.STORAGE, contentLength);
            if (url == null) {
                throw new FileBrokerException("New URL is null.");
            }
        }
        logger.debug((Object)("uploading new file: " + url));
        try {
            md5 = UrlTransferUtil.uploadStream(url, file, this.useChunked, this.useCompression, this.useChecksums, progressListener);
        }
        catch (ChecksumException e) {
            throw new IOException(e);
        }
        logger.debug((Object)("successfully uploaded: " + url + "\tlength: " + contentLength + "\tmd5: " + md5));
        return md5;
    }

    @Override
    public ChecksumInputStream getInputStream(String dataId) throws IOException, FileBrokerException {
        URL url = null;
        try {
            url = this.getURL(dataId);
        }
        catch (FileBrokerException e) {
            logger.error((Object)e);
        }
        if (url == null) {
            throw new FileNotFoundException("file not found or filebroker didn't respond: " + dataId);
        }
        InputStream payload = null;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            connection.setUseCaches(false);
            KeyAndTrustManager.configureForChipsterCertificate(connection);
            connection.connect();
            payload = connection.getInputStream();
        }
        catch (Exception e) {
            IOUtils.closeIfPossible(payload);
            throw e;
        }
        InputStream stream = payload;
        if (url.toString().endsWith(".compressed")) {
            stream = new InflaterInputStream(payload);
        }
        return new ChecksumInputStream(stream, this.useChecksums, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getFile(UUID sessionId, String dataId, File destFile) throws IOException, FileBrokerException, ChecksumException {
        if (this.localFilebrokerCache != null && this.localFilebrokerStorage != null) {
            File fileInFilebrokerCache = new File(this.localFilebrokerCache, dataId);
            File fileInFilebrokerStorage = new File(this.localFilebrokerStorage, dataId);
            File fileInFilebroker = null;
            if (fileInFilebrokerCache.exists()) {
                fileInFilebroker = fileInFilebrokerCache;
            } else if (fileInFilebrokerStorage.exists()) {
                fileInFilebroker = fileInFilebrokerStorage;
            }
            boolean linkCreated = Files.createSymbolicLink(fileInFilebroker, destFile);
            if (linkCreated) return;
            IOUtils.copy(fileInFilebroker, destFile);
            return;
        }
        ChecksumInputStream inputStream = null;
        FileOutputStream fileStream = null;
        try {
            inputStream = this.getInputStream(dataId);
            fileStream = new FileOutputStream(destFile);
            IOUtils.copy((InputStream)new BufferedInputStream(inputStream), new BufferedOutputStream(fileStream));
            inputStream.verifyChecksums();
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(inputStream);
            IOUtils.closeIfPossible(fileStream);
            throw throwable;
        }
        IOUtils.closeIfPossible(inputStream);
        IOUtils.closeIfPossible(fileStream);
    }

    @Override
    public boolean isAvailable(String dataId, Long contentLength, String checksum, FileBrokerClient.FileBrokerArea area) throws FileBrokerException {
        BooleanMessageListener replyListener = new BooleanMessageListener();
        try {
            String contentLengthString = null;
            if (contentLength != null) {
                contentLengthString = contentLength.toString();
            }
            CommandMessage requestMessage = new CommandMessage("is-available");
            requestMessage.addNamedParameter("file-id", dataId);
            requestMessage.addNamedParameter("file-size", contentLengthString);
            requestMessage.addNamedParameter("file-checksum", checksum);
            requestMessage.addNamedParameter("area", area.toString());
            this.filebrokerTopic.sendReplyableMessage(requestMessage, replyListener);
            Boolean success = replyListener.waitForReply(30L, TimeUnit.SECONDS);
            if (success == null) {
                throw new RuntimeException("timeout while waiting for the filebroker");
            }
            boolean bl = success;
            return bl;
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        finally {
            replyListener.cleanUp();
        }
    }

    @Override
    public boolean moveFromCacheToStorage(String dataId) throws FileBrokerException, AuthCancelledException {
        logger.debug((Object)("moving from cache to storage: " + dataId));
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage moveRequestMessage = new CommandMessage("move-from-cache-to-storage");
            moveRequestMessage.addNamedParameter("file-id", dataId);
            this.filebrokerTopic.sendReplyableMessage(moveRequestMessage, replyListener);
            SuccessMessage successMessage = null;
            successMessage = replyListener.waitForReply(24L, TimeUnit.HOURS);
            if (successMessage == null) {
                throw new RuntimeException("timeout while waiting for the filebroker");
            }
            if ("quota-exceeded".equals(successMessage.getErrorMessage())) {
                throw new QuotaExceededException();
            }
            boolean bl = successMessage.success();
            return bl;
        }
        catch (JMSException e) {
            throw new FileBrokerException((Exception)((Object)e));
        }
        finally {
            replyListener.cleanUp();
        }
    }

    @Override
    public List<URL> getPublicFiles() throws FileBrokerException {
        return this.fetchPublicFiles();
    }

    private List<URL> fetchPublicFiles() throws FileBrokerException {
        List<URL> urlList;
        UrlListMessageListener replyListener = new UrlListMessageListener();
        try {
            CommandMessage fileRequestMessage = new CommandMessage("public-url-list-request");
            this.filebrokerTopic.sendReplyableMessage(fileRequestMessage, replyListener);
            urlList = replyListener.waitForReply(30L, TimeUnit.SECONDS);
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        finally {
            replyListener.cleanUp();
        }
        return urlList;
    }

    @Override
    public boolean requestDiskSpace(long size) throws FileBrokerException {
        Boolean spaceAvailable;
        BooleanMessageListener replyListener = new BooleanMessageListener();
        try {
            CommandMessage spaceRequestMessage = new CommandMessage("disk-space-request");
            spaceRequestMessage.addNamedParameter("disk-space", String.valueOf(size));
            this.filebrokerTopic.sendReplyableMessage(spaceRequestMessage, replyListener);
            spaceAvailable = replyListener.waitForReply(300L, TimeUnit.SECONDS);
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        finally {
            replyListener.cleanUp();
        }
        if (spaceAvailable == null) {
            logger.warn((Object)"did not get response for space request");
            return false;
        }
        return spaceAvailable;
    }

    @Override
    public void saveRemoteSession(String sessionName, String sessionId, LinkedList<String> dataIds) throws FileBrokerException, AuthCancelledException {
        ReplyMessageListener replyListener = new ReplyMessageListener();
        try {
            CommandMessage storeRequestMessage = new CommandMessage("store-session");
            storeRequestMessage.addNamedParameter("session-name", sessionName);
            storeRequestMessage.addNamedParameter("session-uuid", sessionId);
            storeRequestMessage.addNamedParameter("file-id-list", Strings.delimit(dataIds, "\t"));
            this.filebrokerTopic.sendReplyableMessage(storeRequestMessage, replyListener);
            ParameterMessage reply = replyListener.waitForReply(30L, TimeUnit.SECONDS);
            if (reply == null) {
                throw new JMSException("failed to save session metadata remotely: reply was null");
            }
            if (!(reply instanceof CommandMessage)) {
                throw new JMSException("failed to save session metadata remotely: reply should be CommandMessage, but is " + reply.getClass().getSimpleName());
            }
            if (!"file-operation-successful".equals(((CommandMessage)reply).getCommand())) {
                throw new JMSException("failed to save session metadata remotely: reply is " + ((CommandMessage)reply).getCommand());
            }
        }
        catch (JMSException e) {
            throw new FileBrokerException((Exception)((Object)e));
        }
        finally {
            replyListener.cleanUp();
        }
    }

    @Override
    public List<DbSession> listRemoteSessions() throws FileBrokerException, AuthCancelledException {
        ReplyMessageListener replyListener = new ReplyMessageListener();
        try {
            CommandMessage listRequestMessage = new CommandMessage("list-sessions");
            this.filebrokerTopic.sendReplyableMessage(listRequestMessage, replyListener);
            ParameterMessage reply = replyListener.waitForReply(30L, TimeUnit.SECONDS);
            if (reply == null) {
                throw new RuntimeException("server failed to list sessions");
            }
            String namesString = reply.getNamedParameter("session-name-list");
            String sessionIdsString = reply.getNamedParameter("session-uuid-list");
            LinkedList<DbSession> sessions = new LinkedList<DbSession>();
            if (namesString != null && !namesString.equals("") && sessionIdsString != null && !sessionIdsString.equals("")) {
                String[] names = namesString.split("\t");
                String[] sessionIds = sessionIdsString.split("\t");
                for (int i = 0; i < names.length && i < sessionIds.length; ++i) {
                    sessions.add(new DbSession(sessionIds[i], names[i], null));
                }
                if (names.length != sessionIds.length) {
                    sessions.clear();
                }
            }
            LinkedList<DbSession> linkedList = sessions;
            return linkedList;
        }
        catch (JMSException e) {
            throw new FileBrokerException((Exception)((Object)e));
        }
        finally {
            replyListener.cleanUp();
        }
    }

    @Override
    public StorageAdminAPI.StorageEntryMessageListener getStorageUsage() throws InterruptedException, FileBrokerException {
        StorageAdminAPI.StorageEntryMessageListener listener = new StorageAdminAPI.StorageEntryMessageListener();
        try {
            listener.query(this.filebrokerTopic, null);
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        return listener;
    }

    @Override
    public List<DbSession> listPublicRemoteSessions() throws FileBrokerException, AuthCancelledException {
        List<DbSession> allSessions = this.listRemoteSessions();
        LinkedList<DbSession> publicSessions = new LinkedList<DbSession>();
        for (DbSession session : allSessions) {
            if (!session.getName().startsWith("Example sessions")) continue;
            publicSessions.add(session);
        }
        return publicSessions;
    }

    @Override
    public void removeRemoteSession(String dataId) throws FileBrokerException, AuthCancelledException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage removeRequestMessage = new CommandMessage("remove-session");
            removeRequestMessage.addNamedParameter("session-uuid", dataId);
            this.filebrokerTopic.sendReplyableMessage(removeRequestMessage, replyListener);
            SuccessMessage reply = replyListener.waitForReply(30L, TimeUnit.SECONDS);
            if (reply == null || !reply.success()) {
                throw new JMSException("failed to remove session");
            }
        }
        catch (JMSException e) {
            throw new FileBrokerException((Exception)((Object)e));
        }
        finally {
            replyListener.cleanUp();
        }
    }

    private URL getNewURL(String dataId, boolean useCompression, FileBrokerClient.FileBrokerArea area, long contentLength) throws FileBrokerException, MalformedURLException {
        URL url;
        logger.debug((Object)"getting new url");
        UrlMessageListener replyListener = new UrlMessageListener();
        try {
            CommandMessage urlRequestMessage = new CommandMessage("new-url-request");
            urlRequestMessage.addNamedParameter("file-id", dataId);
            urlRequestMessage.addNamedParameter("area", area.toString());
            urlRequestMessage.addNamedParameter("disk-space", Long.toString(contentLength));
            if (useCompression) {
                urlRequestMessage.addParameter("use-compression");
            }
            this.filebrokerTopic.sendReplyableMessage(urlRequestMessage, replyListener);
            url = replyListener.waitForReply(300L, TimeUnit.SECONDS);
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        finally {
            replyListener.cleanUp();
        }
        url = this.applyOverridingFilebrokerIp(url);
        logger.debug((Object)("new url is: " + url));
        return url;
    }

    private URL getURL(String dataId) throws FileBrokerException, MalformedURLException {
        URL url;
        logger.debug((Object)("getting url for dataId " + dataId));
        UrlMessageListener replyListener = new UrlMessageListener();
        try {
            CommandMessage getURLMessage = new CommandMessage("get-url");
            getURLMessage.addNamedParameter("file-id", dataId);
            this.filebrokerTopic.sendReplyableMessage(getURLMessage, replyListener);
            url = replyListener.waitForReply(30L, TimeUnit.SECONDS);
        }
        catch (AuthCancelledException | JMSException e) {
            throw new FileBrokerException((Exception)e);
        }
        finally {
            replyListener.cleanUp();
        }
        url = this.applyOverridingFilebrokerIp(url);
        logger.debug((Object)("url is: " + url));
        return url;
    }

    private URL applyOverridingFilebrokerIp(URL url) throws MalformedURLException {
        if (url != null && this.overridingFilebrokerIp != null) {
            logger.debug((Object)("overriding filebroker ip: " + this.overridingFilebrokerIp));
            url = new URL(url.getProtocol(), this.overridingFilebrokerIp, url.getPort(), url.getFile());
        }
        return url;
    }

    @Override
    public String getExternalURL(String dataId) throws FileBrokerException, MalformedURLException {
        return this.getURL(dataId).toExternalForm();
    }

    @Override
    public Long getContentLength(String dataId) throws IOException, FileBrokerException {
        URL url = this.getURL(dataId);
        if (url == null) {
            return null;
        }
        return UrlTransferUtil.getContentLength(url, true);
    }
}

