/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.table;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.ConstantStringFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.table.TableColumnProvider;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.LookaheadLineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class HeaderProvider
extends FeatureProviderBase {
    private static final Logger logger = Logger.getLogger(HeaderProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Feature createFeature(String namePostfix, DataBean bean) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Session.getSession().getDataManager().getContentStream(bean, DataBean.DataNotAvailableHandling.EMPTY_ON_NA)));){
            TableColumnProvider.MatrixParseSettings settings = TableColumnProvider.inferSettings(bean);
            LookaheadLineReader source = new LookaheadLineReader(bufferedReader);
            String header = TableColumnProvider.getHeader(source, settings);
            ConstantStringFeature constantStringFeature = new ConstantStringFeature(bean, this, header);
            return constantStringFeature;
        }
        catch (MicroarrayException | IOException e) {
            throw new RuntimeException(e.getMessage() + " (when reading data header out of " + bean.getName() + ")", e);
        }
    }
}

