/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.ConfigurationLoader;

public class ConfigurationEntry {
    private static final String PROPERTY_REFERENCE_POSTFIX = "}";
    private static final String PROPERTY_REFERENCE_PREFIX = "${";
    private String stringValue;
    private int intValue;
    private boolean booleanValue;
    private Type type;
    private String name;
    private boolean mustBeSet = false;

    public ConfigurationEntry(String name, String typeName) {
        this.type = Type.fromName(typeName);
        this.name = name;
    }

    public void setValue(String value) throws ConfigurationLoader.IllegalConfigurationException {
        if (value.startsWith(PROPERTY_REFERENCE_PREFIX)) {
            String[] split = value.split(PROPERTY_REFERENCE_POSTFIX);
            String systemProperty = System.getProperty(split[0].substring(2));
            value = systemProperty + split[1];
        }
        switch (this.type) {
            case STRING: {
                this.stringValue = value;
                break;
            }
            case INT: {
                try {
                    this.intValue = Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationLoader.IllegalConfigurationException("illegal integer values " + value + " for setting " + this.name);
                }
            }
            case BOOLEAN: {
                if (Boolean.TRUE.toString().equals(value.toLowerCase())) {
                    this.booleanValue = true;
                    break;
                }
                if (Boolean.FALSE.toString().equals(value.toLowerCase())) {
                    this.booleanValue = false;
                    break;
                }
                throw new ConfigurationLoader.IllegalConfigurationException("illegal boolean value " + value + " for setting " + this.name);
            }
            default: {
                throw new RuntimeException("unknown type " + (Object)((Object)this.type));
            }
        }
        this.mustBeSet = false;
    }

    public String getString() {
        this.checkType(Type.STRING);
        return this.stringValue;
    }

    public int getInt() {
        this.checkType(Type.INT);
        return this.intValue;
    }

    public boolean getBoolean() {
        this.checkType(Type.BOOLEAN);
        return this.booleanValue;
    }

    private void checkType(Type suggested) {
        if (this.type != suggested) {
            throw new IllegalArgumentException(this.name + " has type " + (Object)((Object)this.type) + ", not " + (Object)((Object)suggested));
        }
    }

    public void setMustBeSet(boolean mustBeSet) {
        this.mustBeSet = mustBeSet;
    }

    public boolean mustBeSet() {
        return this.mustBeSet;
    }

    public String getName() {
        return this.name;
    }

    static enum Type {
        STRING,
        INT,
        BOOLEAN;


        public static Type fromName(String typeName) {
            return Type.valueOf(typeName.toUpperCase());
        }
    }
}

