/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.SessionReplayTest;
import fi.csc.microarray.comp.ToolTestHtmlFile;
import fi.csc.microarray.comp.ToolTestResult;
import fi.csc.microarray.comp.ToolTestTextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ToolTestSummary {
    private static final String SESSIONS_WITH_ERRORS_FILE = "sessions-with-errors.txt";
    private static final String SESSIONS_WITH_MISSING_TOOLS_FILE = "sessions-with-missing-tools.txt";
    private static final String ALL_TOOLS_FILE = "all-tools.txt";
    public static final String STARTTIME_FILE_NAME = "starttime.txt";
    public static final String ENDTIME_FILE_NAME = "endtime.txt";
    private List<ToolTestResult> toolTestResults = new LinkedList<ToolTestResult>();
    private LinkedHashMap<File, String> sessionsWithErrors = new LinkedHashMap();
    private LinkedHashMap<File, String> sessionsWithMissingTools = new LinkedHashMap();
    final HashMap<String, Integer> uniqueTools = new HashMap();
    private HashMap<String, Integer> failCounts = new HashMap();
    private List<ToolTestResult> failedJobs = new LinkedList<ToolTestResult>();
    private List<ToolTestResult> successfulJobs = new LinkedList<ToolTestResult>();
    private Set<File> uniqueSessions = new HashSet<File>();
    private String[] toolsSortedbyTestCount;
    private HashMap<String, List<File>> toolToSessionsMap = new HashMap();
    private LinkedHashMap<String, String> allTools = new LinkedHashMap();
    private Date startTime;
    private Date endTime;

    public void calculateStats() {
        this.countSuccessfulAndFailedJobs();
        for (ToolTestResult toolTestResult : this.toolTestResults) {
            List<Object> sessionsList;
            if (!this.uniqueTools.containsKey(toolTestResult.getToolId())) {
                this.uniqueTools.put(toolTestResult.getToolId(), 1);
            } else {
                this.uniqueTools.put(toolTestResult.getToolId(), this.uniqueTools.get(toolTestResult.getToolId()) + 1);
            }
            if (!this.toolToSessionsMap.containsKey(toolTestResult.getToolId())) {
                sessionsList = new LinkedList<File>();
                sessionsList.add(toolTestResult.getSession());
                this.toolToSessionsMap.put(toolTestResult.getToolId(), sessionsList);
            } else {
                sessionsList = this.toolToSessionsMap.get(toolTestResult.getToolId());
                if (!sessionsList.contains(toolTestResult.getSession())) {
                    sessionsList.add(toolTestResult.getSession());
                }
            }
            if (this.uniqueSessions.contains(toolTestResult.getSession())) continue;
            this.uniqueSessions.add(toolTestResult.getSession());
        }
        this.toolsSortedbyTestCount = this.uniqueTools.keySet().toArray(new String[0]);
        Arrays.sort(this.toolsSortedbyTestCount, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return ToolTestSummary.this.uniqueTools.get(arg1) - ToolTestSummary.this.uniqueTools.get(arg0);
            }
        });
    }

    private void countSuccessfulAndFailedJobs() {
        for (ToolTestResult toolTestResult : this.toolTestResults) {
            if (SessionReplayTest.TestResult.FAIL.equals((Object)toolTestResult.getTestResult())) {
                this.failedJobs.add(toolTestResult);
                String toolID = toolTestResult.getToolId();
                if (this.failCounts.containsKey(toolID)) {
                    this.failCounts.put(toolID, this.failCounts.get(toolID) + 1);
                    continue;
                }
                this.failCounts.put(toolID, 1);
                continue;
            }
            this.successfulJobs.add(toolTestResult);
        }
    }

    public List<ToolTestResult> getToolTestResults() {
        return this.toolTestResults;
    }

    public List<ToolTestResult> getFailedJobs() {
        return this.failedJobs;
    }

    public List<ToolTestResult> getSuccessfulJobs() {
        return this.successfulJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionsWithErrors(File webDir) throws IOException {
        File results = new File(webDir, SESSIONS_WITH_ERRORS_FILE);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(results));){
            for (File f : this.sessionsWithErrors.keySet()) {
                writer.write(f.getName() + ";;;;" + this.sessionsWithErrors.get(f) + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionsWithMissingTools(File webDir) throws IOException {
        File results = new File(webDir, SESSIONS_WITH_MISSING_TOOLS_FILE);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(results));){
            for (File f : this.sessionsWithMissingTools.keySet()) {
                writer.write(f.getName() + ";;;;" + this.sessionsWithMissingTools.get(f) + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllTools(File webDir) throws IOException {
        File f = new File(webDir, ALL_TOOLS_FILE);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(f));){
            for (String toolId : this.allTools.keySet()) {
                writer.write(toolId + ";;;;" + this.allTools.get(toolId) + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimes(File webDir) throws IOException {
        BufferedWriter writer;
        if (this.startTime != null) {
            writer = new BufferedWriter(new FileWriter(new File(webDir, STARTTIME_FILE_NAME)));
            try {
                writer.write(Long.toString(this.startTime.getTime()));
            }
            finally {
                writer.close();
            }
        }
        if (this.endTime != null) {
            writer = new BufferedWriter(new FileWriter(new File(webDir, ENDTIME_FILE_NAME)));
            try {
                writer.write(Long.toString(this.endTime.getTime()));
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAllTools(File webDir) throws IOException {
        this.allTools = new LinkedHashMap();
        File f = new File(webDir, ALL_TOOLS_FILE);
        if (!f.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    String[] parts = line.split(";;;;", -1);
                    this.allTools.put(parts[0], parts[1]);
                }
                line = reader.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTimes(File webDir) throws IOException, ParseException {
        String line;
        File f = new File(webDir, STARTTIME_FILE_NAME);
        if (!f.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            line = reader.readLine();
            if (!line.trim().isEmpty()) {
                this.startTime = new Date(Long.parseLong(line));
            }
        }
        f = new File(webDir, ENDTIME_FILE_NAME);
        if (!f.exists()) {
            return;
        }
        reader = new BufferedReader(new FileReader(f));
        try {
            line = reader.readLine();
            if (!line.trim().isEmpty()) {
                this.endTime = new Date(Long.parseLong(line));
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSessionsWithErrors(File webDir) throws IOException {
        this.sessionsWithErrors = new LinkedHashMap();
        File results = new File(webDir, SESSIONS_WITH_ERRORS_FILE);
        if (!results.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(results));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    String[] parts = line.split(";;;;", -1);
                    this.sessionsWithErrors.put(new File(parts[0]), parts[1]);
                }
                line = reader.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSessionsWithMissingTools(File webDir) throws IOException {
        this.sessionsWithMissingTools = new LinkedHashMap();
        File results = new File(webDir, SESSIONS_WITH_MISSING_TOOLS_FILE);
        if (!results.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(results));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    String[] parts = line.split(";;;;", -1);
                    this.sessionsWithMissingTools.put(new File(parts[0]), parts[1]);
                }
                line = reader.readLine();
            }
        }
    }

    public void writeToFiles(File webDir) throws IOException {
        ToolTestTextFile.write(this, webDir);
        ToolTestHtmlFile.write(this, webDir);
        this.writeSessionsWithErrors(webDir);
        this.writeSessionsWithMissingTools(webDir);
        this.writeAllTools(webDir);
        this.writeTimes(webDir);
    }

    public void readFromFiles(File webDir) throws IOException, ParseException {
        this.toolTestResults = ToolTestTextFile.parse(webDir);
        this.readSessionsWithErrors(webDir);
        this.readSessionsWithMissingTools(webDir);
        this.readAllTools(webDir);
        this.readTimes(webDir);
    }

    public HashMap<String, Integer> getUniqueTools() {
        return this.uniqueTools;
    }

    public HashMap<String, Integer> getFailCounts() {
        return this.failCounts;
    }

    public LinkedHashMap<File, String> getSessionsWithErrors() {
        return this.sessionsWithErrors;
    }

    public LinkedHashMap<File, String> getSessionsWithMissingTools() {
        return this.sessionsWithMissingTools;
    }

    public Set<File> getUniqueSessions() {
        return this.uniqueSessions;
    }

    public String[] getToolsSortedbyTestCount() {
        return this.toolsSortedbyTestCount;
    }

    public HashMap<String, List<File>> getToolToSessionsMap() {
        return this.toolToSessionsMap;
    }

    public LinkedHashMap<String, String> getAllTools() {
        return this.allTools;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        if (this.startTime != null && this.endTime != null) {
            return this.endTime.getTime() - this.startTime.getTime();
        }
        return -1L;
    }
}

