/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageEstimateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToDetailsConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageEstimateTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.DensityGraphTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSequenceTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.io.IOException;
import java.net.URISyntaxException;

public class SampleTrackGroup
extends TrackGroup {
    private final Color fontColor = Color.black;
    protected CoverageEstimateTrack coverageEstimateTrack;
    protected ReadPileTrack readPileForward;
    protected ReferenceSequenceTrack referenceSequence;
    protected ReadPileTrack readPileReverse;
    protected CoverageTrack coverageTrack;
    protected CoverageAverageTrack coverageAverageTrack;
    protected DensityGraphTrack densityGraphTrack;
    protected SeparatorTrack separatorReadPile;
    protected SeparatorTrack separatorReferenceSequence;
    protected SeparatorTrack separatorDensity;
    protected SeparatorTrack separatorQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    protected SeparatorTrack separatorCoverageEstimate;
    private DataThread referenceSequenceFile;
    private BamToDetailsConversion detailsDataThread;
    private BamToCoverageConversion coverageDataThread;
    private BamToCoverageEstimateConversion estimateDataThread;
    private boolean strandSpecific;
    private boolean coverage;
    private boolean coverageEstimate;
    private boolean reads;
    private boolean highlightSnp;
    private boolean densityGraph;
    private boolean fullMode;
    private boolean markMultimappingReads;
    private Interpretation interpretation;
    private GBrowser browser;
    private GBrowserSettings.CoverageType coverageType = GBrowserSettings.CoverageType.STRAND;

    public SampleTrackGroup(GBrowserView view, Interpretation interpretation, DataThread seqFile, String title, GBrowser browser) {
        super(view);
        super.setName(title);
        this.referenceSequenceFile = seqFile;
        this.interpretation = interpretation;
        this.browser = browser;
        this.setSettingsEnabled(true);
    }

    public void initDataThreads() throws URISyntaxException, IOException {
        if (this.detailsDataThread != null) {
            this.detailsDataThread.clean();
        }
        if (this.coverageDataThread != null) {
            this.coverageDataThread.clean();
        }
        if (this.estimateDataThread != null) {
            this.estimateDataThread.clean();
        }
        if (this.interpretation != null) {
            this.detailsDataThread = this.interpretation.getBamDetailsDataThread(this.browser, GBrowserSettings.CoverageType.STRAND);
            this.coverageDataThread = this.interpretation.getBamCoverageDataThread(this.browser, this.coverageType);
            this.estimateDataThread = this.interpretation.getBamCoverageEstimateDataThread(this.browser, this.coverageType);
        }
    }

    public void initialise() throws URISyntaxException, IOException {
        this.initDataThreads();
        if (this.detailsDataThread != null && this.reads) {
            this.readPileForward = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
            this.readPileForward.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.readPileForward.setView(this.view);
            this.readPileForward.addDataThread(this.detailsDataThread);
            this.readPileForward.setSNPHighlight(this.highlightSnp);
            this.readPileForward.setMarkMultimappingReads(this.markMultimappingReads);
            this.addTrack(this.readPileForward);
            this.separatorReadPile = new SeparatorTrack(Color.gray, 1);
            this.separatorReadPile.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.separatorReadPile.setView(this.view);
            this.separatorReadPile.setTrackName("Reads");
            this.addTrack(this.separatorReadPile);
            this.getStatusAnimation().addDataThread(this.detailsDataThread);
        }
        if (this.referenceSequenceFile != null) {
            this.referenceSequence = new ReferenceSequenceTrack();
            this.referenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.referenceSequence.setView(this.view);
            this.referenceSequence.addDataThread(this.referenceSequenceFile);
            this.addTrack(this.referenceSequence);
            this.separatorReferenceSequence = new SeparatorTrack(Color.gray, 1);
            this.separatorReferenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.separatorReferenceSequence.setView(this.view);
            this.separatorReferenceSequence.setTrackName("Reads");
            this.addTrack(this.separatorReferenceSequence);
            this.getStatusAnimation().addDataThread(this.referenceSequenceFile);
        }
        if (this.detailsDataThread != null) {
            this.addCoverageEstimate();
            if (this.reads) {
                this.readPileReverse = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
                this.readPileReverse.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.readPileReverse.setView(this.view);
                this.readPileReverse.addDataThread(this.detailsDataThread);
                this.readPileReverse.setSNPHighlight(this.highlightSnp);
                this.readPileReverse.setMarkMultimappingReads(this.markMultimappingReads);
                this.readPileReverse.setStrand(Strand.REVERSE);
                this.addTrack(this.readPileReverse);
                if (this.fullMode) {
                    this.readPileForward.setLayoutMode(LayoutTool.LayoutMode.FULL);
                    this.readPileReverse.setLayoutMode(LayoutTool.LayoutMode.FULL);
                }
                SeparatorTrack sepTrackReads2 = new SeparatorTrack(Color.gray, 1);
                sepTrackReads2.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                sepTrackReads2.setView(this.view);
                sepTrackReads2.setTrackName("Reads");
                this.addTrack(sepTrackReads2);
            }
            if (this.coverage) {
                this.coverageTrack = new CoverageTrack(this.coverageDataThread, this.referenceSequenceFile);
                this.coverageTrack.setViewLimits(0L, GBrowserConstants.SHOW_AVERAGES);
                this.coverageTrack.setView(this.view);
                this.coverageTrack.setTrackName("Coverage");
                this.coverageTrack.setStrandSpecificCoverageType(this.strandSpecific);
                this.coverageTrack.setSNPHighlight(this.highlightSnp);
                this.addTrack(this.coverageTrack);
                this.coverageAverageTrack = new CoverageAverageTrack();
                this.coverageAverageTrack.setViewLimits(GBrowserConstants.SHOW_AVERAGES, GBrowserConstants.SWITCH_VIEWS_AT);
                this.coverageAverageTrack.addDataThread(this.coverageDataThread);
                this.coverageAverageTrack.setView(this.view);
                this.coverageAverageTrack.setTrackName("Coverage");
                this.coverageAverageTrack.setStrandSpecificCoverageType(this.strandSpecific);
                this.addTrack(this.coverageAverageTrack);
                this.getStatusAnimation().addDataThread(this.coverageDataThread);
            }
            if (this.coverage && this.densityGraph) {
                this.separatorDensity = new SeparatorTrack(Color.gray, 1);
                this.separatorDensity.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.separatorDensity.setView(this.view);
                this.separatorDensity.setTrackName("DensityGraphTrack");
                this.addTrack(this.separatorDensity);
            }
            if (this.densityGraph) {
                this.densityGraphTrack = new DensityGraphTrack(Color.WHITE);
                this.densityGraphTrack.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.densityGraphTrack.setView(this.view);
                this.densityGraphTrack.addDataThread(this.coverageDataThread);
                this.addTrack(this.densityGraphTrack);
            }
        }
    }

    protected void addCoverageEstimate() {
        if (this.coverageEstimate) {
            this.coverageEstimateTrack = new CoverageEstimateTrack();
            this.coverageEstimateTrack.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, Long.MAX_VALUE);
            this.coverageEstimateTrack.setView(this.view);
            this.coverageEstimateTrack.addDataThread(this.estimateDataThread);
            this.coverageEstimateTrack.setTrackName("CoverageEstimate");
            this.coverageEstimateTrack.setStrandSpecificCoverageType(this.strandSpecific);
            this.addTrack(this.coverageEstimateTrack);
            this.getStatusAnimation().addDataThread(this.estimateDataThread);
        }
    }

    @Override
    public void addTracks() {
        this.tracks.clear();
        if (!this.isMinimized()) {
            this.fullMode = this.isShowMore();
            try {
                this.initialise();
            }
            catch (IOException | URISyntaxException e) {
                this.browser.reportException(e);
            }
        }
    }

    public void setCoverageType(GBrowserSettings.CoverageType type) {
        if (type == GBrowserSettings.CoverageType.NONE) {
            this.coverage = false;
            this.coverageEstimate = false;
        } else if (type == GBrowserSettings.CoverageType.TOTAL) {
            this.coverage = true;
            this.coverageEstimate = true;
            this.strandSpecific = false;
        } else if (type == GBrowserSettings.CoverageType.STRAND) {
            this.coverage = true;
            this.coverageEstimate = true;
            this.strandSpecific = true;
            this.coverageType = type;
            try {
                this.initDataThreads();
            }
            catch (IOException | URISyntaxException e) {
                this.browser.reportException(e);
            }
        } else if (type == GBrowserSettings.CoverageType.STRAND_XS) {
            this.coverage = true;
            this.coverageEstimate = true;
            this.strandSpecific = true;
            this.coverageType = type;
            try {
                this.initDataThreads();
            }
            catch (IOException | URISyntaxException e) {
                this.browser.reportException(e);
            }
        }
        this.addTracks();
    }

    public void setReadsVisible(boolean selected) {
        this.reads = selected;
    }

    public void setHighlightSnp(boolean selected) {
        this.highlightSnp = selected;
        this.addTracks();
    }

    public void setDensityGraphVisible(boolean selected) {
        this.densityGraph = selected;
        this.addTracks();
    }

    public void setMarkMultimappingReads(boolean selected) {
        this.markMultimappingReads = selected;
    }
}

