/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.CoverageStorage;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DensityGraphTrack
extends Track {
    private Color color;
    private Color BACKGROUND = Color.WHITE;
    private CoverageStorage coverageStorage = new CoverageStorage();
    private boolean previousWasAverage;

    public DensityGraphTrack(Color color) {
        this.color = color;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        drawables.add(new RectDrawable(new Rectangle(0, 0, this.getView().getWidth(), this.getTrackHeight()), this.BACKGROUND, this.BACKGROUND));
        boolean isAverage = this.isAverage();
        Iterator<Map.Entry<Region, Float>> averageIter = null;
        Iterator<Map.Entry<BpCoord, BaseStorage.Base>> baseIter = null;
        if (isAverage) {
            averageIter = this.coverageStorage.getTotalAverageCoverage().entrySet().iterator();
        } else {
            baseIter = this.coverageStorage.getTotalBases().entrySet().iterator();
        }
        while (isAverage && averageIter.hasNext() || !isAverage && baseIter.hasNext()) {
            Map.Entry<Comparable<Region>, Object> entry;
            BpCoord startBp = null;
            BpCoord endBp = null;
            Float value = null;
            if (isAverage) {
                entry = averageIter.next();
                startBp = ((Region)entry.getKey()).start;
                endBp = ((Region)entry.getKey()).end;
                value = (Float)entry.getValue();
            } else {
                entry = baseIter.next();
                startBp = (BpCoord)entry.getKey();
                endBp = new BpCoord(((BpCoord)entry.getKey()).bp + 1L, ((BpCoord)entry.getKey()).chr);
                value = Float.valueOf(((BaseStorage.Base)entry.getValue()).getCoverage());
            }
            float hue = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null)[0];
            long startX = this.getView().bpToTrack(startBp).intValue();
            long endX = this.getView().bpToTrack(endBp).intValue();
            float lightness = Math.min(value.floatValue() / (float)this.view.parentPlot.getReadScale().numReads.intValue(), 1.0f);
            Color c = Color.getHSBColor(hue, 0.0f, 1.0f - lightness);
            drawables.add(new RectDrawable(new Rectangle((int)startX, 0, (int)(endX - startX), this.getTrackHeight()), c, c));
        }
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        this.coverageStorage.addBaseCoverage(dataResult, this.view.getRequestRegion());
        this.coverageStorage.addAverages(dataResult, this.view.getRequestRegion());
    }

    @Override
    public int getTrackHeight() {
        return 24;
    }

    private boolean isAverage() {
        return this.coverageStorage.isAverage(this.view.getBpRegion());
    }

    @Override
    public void defineDataTypes() {
        if (this.isAverage()) {
            this.addDataType(DataType.COVERAGE_AVERAGE);
        } else {
            this.addDataType(DataType.COVERAGE);
        }
        boolean isAverage = this.isAverage();
        if (this.previousWasAverage != isAverage) {
            this.view.reloadDataLater();
            this.previousWasAverage = isAverage;
        }
    }

    @Override
    public String getTrackName() {
        return "DensityGraphTrack";
    }

    @Override
    public void updateLayout() {
        if (this.view.parentPlot.getReadScale() == GBrowserPlot.ReadScale.AUTO) {
            this.view.parentPlot.getReadScale().set(this.getMaxTotalCoverage());
        }
    }

    private int getMaxTotalCoverage() {
        float maxValue = 1.0f;
        boolean isAverage = this.isAverage();
        Iterator<Map.Entry<Region, Float>> averageIter = null;
        Iterator<Map.Entry<BpCoord, BaseStorage.Base>> baseIter = null;
        if (isAverage) {
            averageIter = this.coverageStorage.getTotalAverageCoverage().entrySet().iterator();
        } else {
            baseIter = this.coverageStorage.getTotalBases().entrySet().iterator();
        }
        while (isAverage && averageIter.hasNext() || !isAverage && baseIter.hasNext()) {
            Map.Entry<Comparable<Region>, Object> entry;
            Float value = null;
            if (isAverage) {
                entry = averageIter.next();
                value = (Float)entry.getValue();
            } else {
                entry = baseIter.next();
                value = Float.valueOf(((BaseStorage.Base)entry.getValue()).getCoverage());
            }
            maxValue = Math.max(maxValue, value.floatValue());
        }
        return (int)maxValue;
    }
}

