/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ChromosomeBinarySearch;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;

public class ChromosomeBinarySearchTest {
    @Test
    public void run() throws IOException, GBrowserException, URISyntaxException {
        File file = ChromosomeBinarySearchTest.getTestFile();
        DataUrl dataUrl = new DataUrl(file);
        ChromosomeBinarySearch search = new ChromosomeBinarySearch(dataUrl, new GtfLineParser());
        TreeSet<Chromosome> chrs = search.getChromosomes();
        Iterator<Chromosome> chrIter = chrs.iterator();
        for (int i = 0; i < 999; ++i) {
            Chromosome chr = chrIter.next();
            Assert.assertEquals((Object)("" + i), (Object)chr.toNormalisedString());
        }
        file.delete();
    }

    public static File getTestFile() throws IOException {
        File testFile = File.createTempFile("ChromosomeBinarySearchTest-file", ".txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(testFile));
        String[] cols = new String[]{"Source", "Feature", "", "", "Quality", "Strand", "Frame", "Metadata"};
        int TEST_FILE_ROWS = 1000;
        for (int i = 0; i < TEST_FILE_ROWS; ++i) {
            String row = String.format("%03d", i);
            String line = "";
            line = line + "chr" + i + "\t";
            for (String col : cols) {
                line = line + col + row + "\t";
            }
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        return testFile;
    }
}

