/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.SearchRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.util.HashMap;
import java.util.Map;

public class GeneIndexActions
implements DataResultListener {
    private QueueManager queueManager;
    private DataThread gtfDataSource;
    private DataThread geneDataSource;
    private Map<String, GeneLocationListener> listenerMap = new HashMap<String, GeneLocationListener>();

    public GeneIndexActions(QueueManager queueManager, DataThread gtfDataSource, DataThread geneDataSource) {
        this.queueManager = queueManager;
        this.gtfDataSource = gtfDataSource;
        this.geneDataSource = geneDataSource;
        if (gtfDataSource == null && geneDataSource == null) {
            throw new IllegalArgumentException("Both gene search data sources cannot be null");
        }
        this.initializeDataResultListeners();
    }

    public void requestLocation(String gene, GeneLocationListener listener) {
        this.listenerMap.put(gene, listener);
        if (this.geneDataSource != null) {
            this.queueManager.addDataRequest(this.geneDataSource, new SearchRequest(gene, null), null);
        } else if (this.gtfDataSource != null) {
            this.queueManager.addDataRequest(this.gtfDataSource, new SearchRequest(gene, null), null);
        }
    }

    public static boolean checkIfNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(name);
                return true;
            }
            catch (NumberFormatException e1) {
                return false;
            }
        }
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        if (dataResult instanceof GeneResult) {
            GeneResult geneResult = (GeneResult)dataResult;
            this.listenerMap.get(geneResult.getSearchString()).geneLocation(geneResult.getGeneLocation());
            this.listenerMap.remove(geneResult.getSearchString());
        }
    }

    public void initializeDataResultListeners() {
        if (this.gtfDataSource != null) {
            this.queueManager.addDataResultListener(this.gtfDataSource, this);
        }
        if (this.geneDataSource != null) {
            this.queueManager.addDataResultListener(this.geneDataSource, this);
        }
    }

    public static interface GeneLocationListener {
        public void geneLocation(Region var1);
    }
}

