/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class StringParameter
extends Parameter {
    private String value = "";

    protected StringParameter(String id, String displayName, String description, String initValue) {
        super(id, displayName, description);
        if (initValue != null) {
            this.setValue(initValue);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException {
        assert (newValue instanceof String);
        this.value = (String)newValue;
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        return valueObject instanceof String;
    }

    @Override
    public String toString() {
        return this.getID() + ": " + this.value;
    }

    @Override
    public String getValueAsJava() {
        return "\"" + this.value + "\"";
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        stringValue = stringValue == null ? "" : stringValue;
        this.setValue(stringValue);
    }

    @Override
    public String getValueAsString() {
        return this.value != null ? this.value : "";
    }
}

