/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.ColnameParameter;
import fi.csc.microarray.client.operation.parameter.DecimalParameter;
import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.InputSelectParameter;
import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.MetaColnameParameter;
import fi.csc.microarray.client.operation.parameter.PercentageParameter;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class Parameter
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Parameter.class);
    private String id;
    private String displayName;
    private String description;
    private boolean optional = false;

    public static LinkedList<Parameter> cloneParameters(LinkedList<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        LinkedList<Parameter> clones = new LinkedList<Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            clones.add((Parameter)parameters.get(i).clone());
        }
        return clones;
    }

    public void setDataBindings(List<Operation.DataBinding> bindings) throws MicroarrayException {
    }

    public boolean isInputSensitive() {
        return false;
    }

    public static Parameter createInstance(SADLDescription.Name name, SADLSyntax.ParameterType type, SADLDescription.Name[] names, String description, String minValue, String maxValue, String[] initValues, boolean optional) {
        Parameter parameter = null;
        String initValue = null;
        if (initValues.length > 0) {
            initValue = initValues[0];
        }
        logger.debug((Object)("creating instance of " + type.name() + " parameter called " + name + ", value: " + initValue));
        switch (type) {
            case ENUM: {
                int minCount = minValue != null ? Integer.parseInt(minValue) : 0;
                int maxCount = maxValue != null ? Integer.parseInt(maxValue) : 1;
                String[] titles = new String[names.length];
                String[] values = new String[names.length];
                int i = 0;
                for (SADLDescription.Name option : names) {
                    titles[i] = option.getDisplayName();
                    values[i] = option.getID();
                    ++i;
                }
                EnumParameter.SelectionOption[] optionObjects = EnumParameter.SelectionOption.convertStrings(titles, values);
                LinkedList<EnumParameter.SelectionOption> defaultOptions = new LinkedList<EnumParameter.SelectionOption>();
                if (initValue != null) {
                    for (String value : initValues) {
                        for (EnumParameter.SelectionOption option : optionObjects) {
                            if (!value.equals(option.getValue())) continue;
                            defaultOptions.add(option);
                        }
                    }
                }
                parameter = new EnumParameter(name.getID(), name.getDisplayName(), description, optionObjects, defaultOptions, minCount, maxCount);
                break;
            }
            case COLUMN_SEL: {
                parameter = new ColnameParameter(name.getID(), name.getDisplayName(), description, initValue);
                break;
            }
            case METACOLUMN_SEL: {
                parameter = new MetaColnameParameter(name.getID(), name.getDisplayName(), description, initValue);
                break;
            }
            case INPUT_SEL: {
                parameter = new InputSelectParameter(name.getID(), name.getDisplayName(), description, initValue);
                break;
            }
            case STRING: {
                parameter = new StringParameter(name.getID(), name.getDisplayName(), description, initValue);
                break;
            }
            case INTEGER: 
            case DECIMAL: 
            case PERCENT: {
                Float min = Float.valueOf(minValue == null ? -3.4028235E38f : Float.parseFloat(minValue));
                Float max = Float.valueOf(maxValue == null ? Float.MAX_VALUE : Float.parseFloat(maxValue));
                Float init = null;
                Integer initInt = null;
                if (initValue != null) {
                    init = Float.valueOf(Float.parseFloat(initValue));
                    initInt = Math.round(init.floatValue());
                }
                switch (type) {
                    case INTEGER: {
                        parameter = new IntegerParameter(name.getID(), name.getDisplayName(), description, Math.round(min.floatValue()), Math.round(max.floatValue()), initInt);
                        break;
                    }
                    case DECIMAL: {
                        parameter = new DecimalParameter(name.getID(), name.getDisplayName(), description, min, max, init);
                        break;
                    }
                    case PERCENT: {
                        min = Float.valueOf(min.floatValue() < 0.0f ? 0.0f : min.floatValue());
                        max = Float.valueOf(max.floatValue() > 100.0f ? 100.0f : max.floatValue());
                        parameter = new PercentageParameter(name.getID(), name.getDisplayName(), description, Math.round(min.floatValue()), Math.round(max.floatValue()), initInt);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type " + (Object)((Object)type));
            }
        }
        parameter.setOptional(optional);
        return parameter;
    }

    protected Parameter(String id, String displayName, String description) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        return this.id;
    }

    public String getDisplayName(Integer maxLength) {
        if (this.getDisplayName().length() > maxLength) {
            return this.getDisplayName().substring(0, maxLength - 3) + "...";
        }
        return this.getDisplayName();
    }

    public abstract Object getValue();

    public abstract String getValueAsJava();

    public abstract String getValueAsString();

    public abstract void setValue(Object var1) throws IllegalArgumentException;

    public abstract void parseValue(String var1) throws IllegalArgumentException;

    public abstract boolean checkValidityOf(Object var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract String toString();

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

