/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.NameID;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class OperationRecord {
    private NameID nameID = new NameID();
    private String categoryName;
    private Color categoryColor;
    private String moduleName;
    private String sourceCode;
    private LinkedHashMap<String, ParameterRecord> parameters = new LinkedHashMap();
    private LinkedHashMap<String, InputRecord> inputs = new LinkedHashMap();
    private String jobId;
    private Date startTime;
    private Date endTime;

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public OperationRecord(Operation operation) {
        this.nameID.setId(operation.getID());
        this.nameID.setDisplayName(operation.getDisplayName());
        this.nameID.setDescription(operation.getDescription());
        this.categoryName = operation.getCategoryName();
        this.categoryColor = operation.getCategoryColor();
        if (operation.getDefinition().getCategory().getModule() != null) {
            this.moduleName = operation.getDefinition().getCategory().getModule().getModuleName();
        }
        for (Parameter parameter : operation.getParameters()) {
            this.parameters.put(parameter.getID(), new ParameterRecord(parameter));
        }
        for (Operation.DataBinding binding : operation.getBindings()) {
            OperationDefinition.InputDefinition inputDefinition = operation.getDefinition().getInput(binding.getName());
            String displayName = inputDefinition.isMulti() ? inputDefinition.getDisplayName(binding.getName()) : inputDefinition.getDisplayName();
            this.inputs.put(binding.getName(), new InputRecord(binding.getName(), displayName, inputDefinition.getDescription(), binding.getData()));
        }
        this.sourceCode = "not yet available";
    }

    public OperationRecord() {
    }

    public NameID getNameID() {
        return this.nameID;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getModule() {
        return this.moduleName;
    }

    public String getFullName() {
        return this.getCategoryName() + " / " + this.nameID.getDisplayName();
    }

    public Color getCategoryColor() {
        return this.categoryColor;
    }

    public Collection<ParameterRecord> getParameters() {
        return this.parameters.values();
    }

    public ParameterRecord getParameter(String id) {
        return this.parameters.get(id);
    }

    public Collection<InputRecord> getInputRecords() {
        return this.inputs.values();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setModule(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setCategoryColor(Color categoryColor) {
        this.categoryColor = categoryColor;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.put(parameter.getID(), new ParameterRecord(parameter));
    }

    public void addParameter(String id, String displayName, String description, String value) {
        this.parameters.put(id, new ParameterRecord(id, displayName, description, value));
    }

    public void addInput(NameID nameID, DataBean dataBean) {
        this.inputs.put(nameID.getID(), new InputRecord(nameID, dataBean));
    }

    public void addInput(NameID nameId, String dataId) {
        this.inputs.put(this.nameID.getID(), new InputRecord(this.nameID, dataId));
    }

    public void removeInput(DataBean inputBean) {
        if (inputBean == null) {
            return;
        }
        for (InputRecord inputRecord : this.inputs.values()) {
            if (inputRecord.getValue() != inputBean) continue;
            inputRecord.setValue(null);
        }
    }

    public void setNameID(NameID nameID) {
        this.nameID = nameID;
    }

    public static OperationRecord getUnkownOperationRecord() {
        OperationRecord record = new OperationRecord();
        record.setNameID(new NameID("unknown", "Unknown", "No tool information available."));
        record.setCategoryName("Unknown");
        record.setCategoryColor(ToolCategory.UNKNOWN_CATEGORY_COLOR);
        record.setSourceCode("Source code not available.");
        return record;
    }

    public Iterable<DataBean> getInputDataBeans() {
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        for (InputRecord input : this.getInputRecords()) {
            beans.add(input.getValue());
        }
        return beans;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public class InputRecord
    extends DataBeanRecord {
        public InputRecord(NameID nameID, DataBean value) {
            super(nameID, value);
        }

        public InputRecord(String id, String displayName, String description, DataBean value) {
            super(id, displayName, description, value);
        }

        public InputRecord(NameID nameID, String dataId) {
            super(nameID, dataId);
        }
    }

    private class DataBeanRecord {
        private NameID nameID;
        private String dataId;
        private DataBean value;

        public DataBeanRecord(NameID nameID, DataBean value) {
            this.nameID = nameID;
            if (value != null) {
                this.dataId = value.getId();
            }
            this.value = value;
        }

        public DataBeanRecord(String id, String displayName, String description, DataBean value) {
            this(new NameID(id, displayName, description), value);
        }

        public DataBeanRecord(NameID nameID, String dataId) {
            this.nameID = nameID;
            this.dataId = dataId;
            this.value = null;
        }

        public NameID getNameID() {
            return this.nameID;
        }

        public String getDataId() {
            return this.dataId;
        }

        public DataBean getValue() {
            return this.value;
        }

        public void setValue(DataBean value) {
            this.value = value;
        }
    }

    public class ParameterRecord
    extends StringRecord {
        public ParameterRecord(String id, String displayName, String description, String value) {
            super(id, displayName, description, value);
        }

        public ParameterRecord(Parameter parameter) {
            super(parameter.getID(), parameter.getDisplayName(), parameter.getDescription(), parameter.getValueAsString());
        }
    }

    private class StringRecord {
        private NameID nameID;
        private String value;

        public StringRecord(String id, String displayName, String description, String value) {
            this.nameID = new NameID(id, displayName, description);
            this.value = value;
        }

        public NameID getNameID() {
            return this.nameID;
        }

        public String getValue() {
            return this.value;
        }
    }
}

