/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class SequenceImportDialog
extends JDialog
implements CaretListener,
ActionListener {
    private static final String OPERATION_ID_FOR_MULTIPLE_IDENTIFIERS = "retrieve-sequences-from-database.sadl";
    private static final String OPERATION_ID_FOR_SINGLE_IDENTIFIER = "importseq.sadl";
    private static final String STYLE_FOR_HINTS = "style=\"font-size: 90%\"";
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private static Logger logger = Logger.getLogger(SequenceImportDialog.class);
    private ClientApplication application;
    private JLabel textLabel;
    private JTextField beginField;
    private JTextField endField;
    private JTextArea textArea;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox dbNameCombo;

    public SequenceImportDialog(ClientApplication clientApplication) {
        super((Frame)Session.getSession().getFrames().getMainFrame(), true);
        this.application = clientApplication;
        this.setTitle("Import sequence");
        this.setModal(true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.setLayout(new GridBagLayout());
        this.dbNameCombo = new JComboBox<Databases>(Databases.values());
        this.dbNameCombo.setPreferredSize(new Dimension(150, 20));
        this.dbNameCombo.setBackground(Color.WHITE);
        this.dbNameCombo.setSelectedItem((Object)Databases.UNIPROT_SWISS);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Database"), c);
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.dbNameCombo, c);
        this.textLabel = new JLabel("Sequence identifier(s)");
        c.anchor = 17;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)this.textLabel, c);
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setBorder(BorderFactory.createEmptyBorder());
        this.textArea.addCaretListener(this);
        this.textArea.setText("CASA1_HUMAN\nCASA1_MOUSE");
        this.textArea.selectAll();
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        areaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        areaScrollPane.setPreferredSize(new Dimension(400, 90));
        c.insets.set(0, 10, 0, 10);
        ++c.gridy;
        this.add((Component)areaScrollPane, c);
        this.beginField = new JTextField(4);
        this.endField = new JTextField(4);
        JPanel rangePanel = new JPanel(new GridBagLayout());
        GridBagConstraints rangeConstraints = new GridBagConstraints();
        rangeConstraints.weightx = 1.0;
        rangeConstraints.weighty = 1.0;
        rangeConstraints.anchor = 17;
        rangeConstraints.insets.set(0, 0, 0, 10);
        rangeConstraints.gridx = 0;
        rangeConstraints.gridy = 0;
        rangePanel.add((Component)new JLabel("Start"), rangeConstraints);
        ++rangeConstraints.gridx;
        rangePanel.add((Component)this.beginField, rangeConstraints);
        ++rangeConstraints.gridx;
        rangePanel.add((Component)new JLabel("End"), rangeConstraints);
        ++rangeConstraints.gridx;
        rangePanel.add((Component)this.endField, rangeConstraints);
        rangeConstraints.gridx = 0;
        ++rangeConstraints.gridy;
        rangeConstraints.gridwidth = 4;
        rangeConstraints.anchor = 13;
        c.insets.set(10, 10, 0, 10);
        ++c.gridy;
        c.fill = 0;
        this.add((Component)rangePanel, c);
        c.insets.set(0, 10, 0, 10);
        ++c.gridy;
        c.fill = 0;
        this.add((Component)new JLabel("<html><p style=\"font-size: 90%\">Only applies for a single identifier</p></html>"), c);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        JPanel keepButtonsRightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.weightx = 1.0;
        buttonConstraints.weighty = 1.0;
        buttonConstraints.anchor = 13;
        buttonConstraints.insets.set(0, 0, 0, 8);
        keepButtonsRightPanel.add((Component)this.cancelButton, buttonConstraints);
        buttonConstraints.gridx = -1;
        buttonConstraints.insets.set(0, 0, 0, 0);
        keepButtonsRightPanel.add((Component)this.okButton, buttonConstraints);
        c.insets.set(10, 10, 10, 10);
        c.anchor = 14;
        ++c.gridy;
        c.fill = 0;
        this.add((Component)keepButtonsRightPanel, c);
        this.pack();
        this.setResizable(false);
        Session.getSession().getFrames().setLocationRelativeToMainFrame(this);
        this.textArea.requestFocusInWindow();
        this.setVisible(true);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            Integer send;
            Integer sbegin;
            String db = ((Databases)((Object)this.dbNameCombo.getSelectedItem())).getValue();
            String identifiersText = this.textArea.getText().trim();
            LinkedList<String> idList = new LinkedList<String>();
            for (String id : identifiersText.split("[\\s|;|,]+")) {
                if (id.isEmpty()) continue;
                idList.add(id);
            }
            try {
                sbegin = Integer.parseInt(this.beginField.getText());
            }
            catch (NumberFormatException nfe) {
                sbegin = null;
            }
            try {
                send = Integer.parseInt(this.endField.getText());
            }
            catch (NumberFormatException nfe) {
                send = null;
            }
            if (idList.size() > 0) {
                this.runImport(db, idList.toArray(new String[0]), sbegin, send);
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    private void runImport(String db, String[] identifiers, Integer sbegin, Integer send) {
        try {
            Operation operation;
            logger.info((Object)"Importing sequence...");
            String identifiersString = "";
            for (String identifier : identifiers) {
                identifiersString = identifiersString + identifier + "\n";
            }
            if (identifiers.length == 1) {
                operation = new Operation(this.application.getOperationDefinition(OPERATION_ID_FOR_SINGLE_IDENTIFIER), new DataBean[0]);
                operation.setParameter("sequence", db + ":" + identifiers[0]);
                operation.setParameter("sbegin", sbegin);
                operation.setParameter("send", send);
            } else {
                operation = new Operation(this.application.getOperationDefinition(OPERATION_ID_FOR_MULTIPLE_IDENTIFIERS), new DataBean[0]);
                operation.setParameter("source", db);
                operation.bindInputs(new DataBean[]{Session.getSession().getDataManager().createDataBean("identifiers.txt", new ByteArrayInputStream(identifiersString.getBytes()))});
            }
            this.application.executeOperation(operation);
        }
        catch (Exception exc) {
            this.application.reportException(exc);
        }
    }

    private static enum Databases {
        EMBL("EMBL", "embl"),
        EMBL_NEW("EMBL New", "emblnew"),
        PDB("PDB", "pdb_seq"),
        UNIPROT_SWISS("UniProt / SwissProt", "swiss"),
        UNIPROT_TREMBL("UniProt / TrEMBL", "trembl"),
        ENSEMBL("Ensembl", "ensembl");

        private String name;
        private String value;

        private Databases(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

