/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web;

import fi.csc.chipster.rest.Config;
import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class WebServer {
    private static final Logger logger = LogManager.getLogger();
    private Config config;
    private Server server;

    public WebServer(Config config) {
        this.config = config;
    }

    public void start() throws Exception {
        URI baseUri = this.config.getURI("web-bind");
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(baseUri.getPort());
        connector.setHost(baseUri.getHost());
        this.server.addConnector((Connector)connector);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        String rootPath = this.config.getString("web-root-path");
        resourceHandler.setResourceBase(rootPath);
        File root = new File(rootPath);
        logger.info("web root: " + root.getCanonicalPath());
        if (!root.exists()) {
            throw new IllegalArgumentException("web root " + rootPath + " doesn't exist");
        }
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)resourceHandler);
        contextHandler.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{contextHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    public static void main(String[] args) throws Exception {
        new WebServer(new Config()).start();
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("failed to stop the web server", (Throwable)e);
        }
    }
}

