/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import fi.csc.chipster.toolbox.RuntimeUtils;
import fi.csc.chipster.toolbox.ToolboxModule;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.chipster.toolbox.toolpartsparser.HeaderAsCommentParser;
import fi.csc.chipster.toolbox.toolpartsparser.JavaParser;
import fi.csc.chipster.toolbox.toolpartsparser.ToolPartsParser;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Toolbox {
    private static Logger logger = LogManager.getLogger();
    private List<ToolboxModule> modules = new LinkedList<ToolboxModule>();
    private byte[] zipContents;

    public Toolbox(Path modulesDir, File toolsBin) throws IOException {
        this.modules.addAll(Toolbox.loadModuleDescriptions(modulesDir, toolsBin));
    }

    public ToolboxTool getTool(String id) {
        for (ToolboxModule module : this.modules) {
            ToolboxTool tool = module.getTool(id);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public List<ToolboxTool> getAll() {
        LinkedList<ToolboxTool> list = new LinkedList<ToolboxTool>();
        for (ToolboxModule module : this.modules) {
            list.addAll(module.getAll());
        }
        return list;
    }

    public List<ToolboxModule> getModules() {
        return this.modules;
    }

    public ToolboxModule getModule(String name) {
        for (ToolboxModule module : this.modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public List<ModuleDescriptionMessage> getModuleDescriptions() {
        LinkedList<ModuleDescriptionMessage> moduleDescriptions = new LinkedList<ModuleDescriptionMessage>();
        for (ToolboxModule module : this.modules) {
            moduleDescriptions.add(module.getModuleDescriptionMessage());
        }
        return moduleDescriptions;
    }

    public static List<ToolboxModule> loadModuleDescriptions(Path modulesDir, File toolsBin) throws IOException {
        LinkedList<ToolboxModule> modulesList = new LinkedList<ToolboxModule>();
        LinkedList<String> moduleLoadSummaries = new LinkedList<String>();
        try (DirectoryStream<Path> modulesDirStream = Files.newDirectoryStream(modulesDir);){
            for (Path moduleDir : modulesDirStream) {
                if (!Files.isDirectory(moduleDir, new LinkOption[0])) continue;
                DirectoryStream<Path> moduleDirStream = Files.newDirectoryStream(moduleDir, "*-module.xml");
                Throwable throwable = null;
                try {
                    for (Path moduleFile : moduleDirStream) {
                        String summary;
                        ToolboxModule module;
                        logger.info("loading tools specifications from: " + moduleFile);
                        try {
                            module = new ToolboxModule(moduleDir, moduleFile, toolsBin);
                            summary = module.getSummary();
                        }
                        catch (Exception e) {
                            logger.warn("loading " + moduleFile + " failed", (Throwable)e);
                            continue;
                        }
                        modulesList.add(module);
                        moduleLoadSummaries.add(summary);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (moduleDirStream == null) continue;
                    if (throwable != null) {
                        try {
                            moduleDirStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    moduleDirStream.close();
                }
            }
        }
        logger.info("------ tool summary ------ ");
        for (String summary : moduleLoadSummaries) {
            logger.info(summary);
        }
        logger.info("------ tool summary ------ ");
        return modulesList;
    }

    public void setZipContents(byte[] zipContents) {
        this.zipContents = zipContents;
    }

    public InputStream getZipStream() {
        return new ByteArrayInputStream(this.zipContents);
    }

    public byte[] getZipContents() {
        return this.zipContents;
    }

    static ToolPartsParser getToolPartsParser(String toolId) {
        if (toolId == null || toolId.isEmpty()) {
            return null;
        }
        String defaultRuntime = Toolbox.getDefaultRuntime(toolId);
        if (defaultRuntime == null) {
            return null;
        }
        if (defaultRuntime.startsWith("python")) {
            return new HeaderAsCommentParser("#", RuntimeUtils.getToolDirFromRuntimeName((String)defaultRuntime));
        }
        if (defaultRuntime.startsWith("java")) {
            return new JavaParser();
        }
        if (defaultRuntime.startsWith("R")) {
            return new HeaderAsCommentParser("#", RuntimeUtils.getToolDirFromRuntimeName((String)defaultRuntime));
        }
        return null;
    }

    static String getDefaultRuntime(String toolId) {
        if (toolId == null || toolId.isEmpty()) {
            return null;
        }
        if (toolId.endsWith(".R")) {
            return "R";
        }
        if (toolId.endsWith(".py")) {
            return "python";
        }
        if (toolId.endsWith(".java")) {
            return "java";
        }
        return null;
    }
}

