/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.sessiondb.model.Authorization;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.resource.AuthorizationResource;
import fi.csc.chipster.sessiondb.resource.DatasetResource;
import fi.csc.chipster.sessiondb.resource.JobResource;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.SessionEventListener;

@Path(value="sessions")
public class SessionResource {
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;
    private PubSubServer events;
    private AuthorizationResource authorizationResource;

    public SessionResource(HibernateUtil hibernate, AuthorizationResource authorizationResource) {
        this.hibernate = hibernate;
        this.authorizationResource = authorizationResource;
    }

    @Path(value="{id}/datasets")
    public DatasetResource getDatasetResource(@PathParam(value="id") UUID id) {
        return new DatasetResource(this, id);
    }

    @Path(value="{id}/jobs")
    public JobResource getJobResource(@PathParam(value="id") UUID id) {
        return new JobResource(this, id);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Transaction
    public Response get(@PathParam(value="id") UUID sessionId, @Context SecurityContext sc) throws IOException {
        Session result = this.getSessionForReading(sc, sessionId);
        if (result == null) {
            throw new NotFoundException();
        }
        result.setAccessed(LocalDateTime.now());
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transaction
    public Response getAll(@Context SecurityContext sc) {
        List<Authorization> result = this.authorizationResource.getAuthorizations(sc.getUserPrincipal().getName());
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Authorization auth : result) {
            sessions.add(auth.getSession());
        }
        return Response.ok(this.toJaxbList(sessions)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Transaction
    public Response post(Session session, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        if (session.getSessionId() != null) {
            throw new BadRequestException("session already has an id, post not allowed");
        }
        UUID id = RestUtils.createUUID();
        session.setSessionId(id);
        session.setCreated(LocalDateTime.now());
        session.setAccessed(LocalDateTime.now());
        String username = sc.getUserPrincipal().getName();
        if (username == null) {
            throw new NotAuthorizedException("username is null");
        }
        Authorization auth = new Authorization(username, session, true);
        auth.setAuthorizationId(RestUtils.createUUID());
        this.create(auth, this.getHibernate().session());
        URI uri = uriInfo.getAbsolutePathBuilder().path(id.toString()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    public void create(Authorization auth, org.hibernate.Session hibernateSession) {
        this.authorizationResource.save(auth, hibernateSession);
        UUID sessionId = auth.getSession().getSessionId();
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.SESSION, sessionId, SessionEvent.EventType.CREATE), hibernateSession);
        this.publish("authorizations", new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, auth.getAuthorizationId(), SessionEvent.EventType.CREATE), hibernateSession);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Transaction
    public Response put(Session requestSession, @PathParam(value="id") UUID sessionId, @Context SecurityContext sc) {
        requestSession.setSessionId(sessionId);
        this.getWriteAuthorization(sc, sessionId);
        requestSession.setAccessed(LocalDateTime.now());
        this.update(requestSession, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void update(Session session, org.hibernate.Session hibernateSession) {
        UUID sessionId = session.getSessionId();
        hibernateSession.merge((Object)session);
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.SESSION, sessionId, SessionEvent.EventType.UPDATE), hibernateSession);
    }

    @DELETE
    @Path(value="{id}")
    @Transaction
    public Response delete(@PathParam(value="id") UUID id, @Context SecurityContext sc) {
        Authorization auth = this.getWriteAuthorization(sc, id);
        this.deleteSession(auth, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void deleteSession(Authorization auth, org.hibernate.Session hibernateSession) {
        UUID sessionId = auth.getSession().getSessionId();
        for (Dataset dataset : auth.getSession().getDatasets().values()) {
            this.getDatasetResource(sessionId).deleteDataset(dataset, hibernateSession);
        }
        for (Job job : auth.getSession().getJobs().values()) {
            this.getJobResource(sessionId).deleteJob(job, hibernateSession);
        }
        hibernateSession.delete((Object)auth);
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, sessionId, SessionEvent.EventType.DELETE), hibernateSession);
        this.publish("authorizations", new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, auth.getAuthorizationId(), SessionEvent.EventType.DELETE), hibernateSession);
    }

    public Session getSessionForReading(SecurityContext sc, UUID sessionId) {
        Authorization auth = this.authorizationResource.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, false);
        return auth.getSession();
    }

    public Session getSessionForWriting(SecurityContext sc, UUID sessionId) {
        Authorization auth = this.authorizationResource.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, true);
        return auth.getSession();
    }

    public Authorization getReadAuthorization(SecurityContext sc, UUID sessionId) {
        return this.authorizationResource.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, false);
    }

    public Authorization getWriteAuthorization(SecurityContext sc, UUID sessionId) {
        return this.authorizationResource.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, true);
    }

    private GenericEntity<List<Session>> toJaxbList(List<Session> result) {
        return new GenericEntity<List<Session>>(result){};
    }

    public HibernateUtil getHibernate() {
        return this.hibernate;
    }

    public void setPubSubServer(PubSubServer pubSubServer) {
        this.events = pubSubServer;
    }

    public void publish(final String topic, final SessionEvent obj, org.hibernate.Session hibernateSession) {
        hibernateSession.addEventListeners(new SessionEventListener[]{new BaseSessionEventListener(){

            public void transactionCompletion(boolean successful) {
                SessionResource.this.events.publish(topic, obj);
                if (SessionEvent.ResourceType.JOB == obj.getResourceType()) {
                    SessionResource.this.events.publish("jobs", obj);
                }
                if (SessionEvent.ResourceType.SESSION == obj.getResourceType()) {
                    SessionResource.this.events.publish("sessions", obj);
                }
                if (SessionEvent.ResourceType.DATASET == obj.getResourceType()) {
                    SessionResource.this.events.publish("datasets", obj);
                }
            }
        }});
    }

    public AuthorizationResource getAuthorizationResource() {
        return this.authorizationResource;
    }
}

