/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.model;

import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@XmlRootElement
public class Session {
    @Id
    @Column(columnDefinition="uuid", updatable=false)
    private UUID sessionId;
    private String name;
    @Lob
    private String notes;
    private LocalDateTime created;
    private LocalDateTime accessed;
    @OneToMany(mappedBy="session")
    private Collection<Dataset> datasets;
    @OneToMany(mappedBy="session")
    private Collection<Job> jobs;

    @XmlTransient
    public Map<UUID, Job> getJobs() {
        HashMap<UUID, Job> map = new HashMap<UUID, Job>();
        for (Job job : this.jobs) {
            map.put(job.getJobId(), job);
        }
        return map;
    }

    public void setJobs(Map<UUID, Job> jobs) {
        this.jobs = jobs.values();
    }

    @XmlTransient
    public Map<UUID, Dataset> getDatasets() {
        HashMap<UUID, Dataset> map = new HashMap<UUID, Dataset>();
        for (Dataset dataset : this.datasets) {
            map.put(dataset.getDatasetId(), dataset);
        }
        return map;
    }

    @XmlTransient
    public Collection<Dataset> getDatasetCollection() {
        return this.datasets;
    }

    public void setDatasets(Map<UUID, Dataset> datasets) {
        this.datasets = datasets.values();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(UUID id) {
        this.sessionId = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public LocalDateTime getAccessed() {
        return this.accessed;
    }

    public void setAccessed(LocalDateTime accessed) {
        this.accessed = accessed;
    }
}

